<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitReservationsType StructType
 * @subpackage Structs
 */
class UnitReservationsType extends AbstractStructBase
{
    /**
     * The UnitReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitReservationType[]
     */
    public $UnitReservation;
    /**
     * The RoutingHops
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfRoutingHopTypeRoutingHop
     */
    public $RoutingHops;
    /**
     * The WrittenConfInst
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\WrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * Constructor method for UnitReservationsType
     * @uses UnitReservationsType::setUnitReservation()
     * @uses UnitReservationsType::setRoutingHops()
     * @uses UnitReservationsType::setWrittenConfInst()
     * @uses UnitReservationsType::setTPA_Extensions()
     * @param \rdyescapia\StructType\UnitReservationType[] $unitReservation
     * @param \rdyescapia\ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops
     * @param \rdyescapia\StructType\WrittenConfInstType $writtenConfInst
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     */
    public function __construct(array $unitReservation = array(), \rdyescapia\ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops = null, \rdyescapia\StructType\WrittenConfInstType $writtenConfInst = null, \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this
            ->setUnitReservation($unitReservation)
            ->setRoutingHops($routingHops)
            ->setWrittenConfInst($writtenConfInst)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get UnitReservation value
     * @return \rdyescapia\StructType\UnitReservationType[]|null
     */
    public function getUnitReservation()
    {
        return $this->UnitReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitReservationForArrayConstraintsFromSetUnitReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitReservationsTypeUnitReservationItem) {
            // validation for constraint: itemType
            if (!$unitReservationsTypeUnitReservationItem instanceof \rdyescapia\StructType\UnitReservationType) {
                $invalidValues[] = is_object($unitReservationsTypeUnitReservationItem) ? get_class($unitReservationsTypeUnitReservationItem) : sprintf('%s(%s)', gettype($unitReservationsTypeUnitReservationItem), var_export($unitReservationsTypeUnitReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitReservation property can only contain items of type \rdyescapia\StructType\UnitReservationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitReservation value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitReservationType[] $unitReservation
     * @return \rdyescapia\StructType\UnitReservationsType
     */
    public function setUnitReservation(array $unitReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($unitReservationArrayErrorMessage = self::validateUnitReservationForArrayConstraintsFromSetUnitReservation($unitReservation))) {
            throw new \InvalidArgumentException($unitReservationArrayErrorMessage, __LINE__);
        }
        $this->UnitReservation = $unitReservation;
        return $this;
    }
    /**
     * Add item to UnitReservation value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitReservationType $item
     * @return \rdyescapia\StructType\UnitReservationsType
     */
    public function addToUnitReservation(\rdyescapia\StructType\UnitReservationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitReservationType) {
            throw new \InvalidArgumentException(sprintf('The UnitReservation property can only contain items of type \rdyescapia\StructType\UnitReservationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitReservation[] = $item;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return \rdyescapia\ArrayType\ArrayOfRoutingHopTypeRoutingHop|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param \rdyescapia\ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops
     * @return \rdyescapia\StructType\UnitReservationsType
     */
    public function setRoutingHops(\rdyescapia\ArrayType\ArrayOfRoutingHopTypeRoutingHop $routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \rdyescapia\StructType\WrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \rdyescapia\StructType\WrittenConfInstType $writtenConfInst
     * @return \rdyescapia\StructType\UnitReservationsType
     */
    public function setWrittenConfInst(\rdyescapia\StructType\WrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\UnitReservationsType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitReservationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
