<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResResponseType StructType
 * @subpackage Structs
 */
class UnitResResponseType extends EVRN_BaseRSType
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfSourceType
     */
    public $POS;
    /**
     * The UnitReservations
     * Meta information extracted from the WSDL
     * - choice: UnitReservations | Errors | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - choice: UnitReservations | Errors | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - choice: UnitReservations | Errors | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - choice: UnitReservations | Errors | Success | Warnings
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\WarningsType
     */
    public $Warnings;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for UnitResResponseType
     * @uses UnitResResponseType::setPOS()
     * @uses UnitResResponseType::setUnitReservations()
     * @uses UnitResResponseType::setErrors()
     * @uses UnitResResponseType::setSuccess()
     * @uses UnitResResponseType::setWarnings()
     * @uses UnitResResponseType::setResResponseType()
     * @param \rdyescapia\ArrayType\ArrayOfSourceType $pOS
     * @param \rdyescapia\StructType\UnitReservationsType $unitReservations
     * @param \rdyescapia\StructType\ErrorsType $errors
     * @param \rdyescapia\StructType\SuccessType $success
     * @param \rdyescapia\StructType\WarningsType $warnings
     * @param string $resResponseType
     */
    public function __construct(\rdyescapia\ArrayType\ArrayOfSourceType $pOS = null, \rdyescapia\StructType\UnitReservationsType $unitReservations = null, \rdyescapia\StructType\ErrorsType $errors = null, \rdyescapia\StructType\SuccessType $success = null, \rdyescapia\StructType\WarningsType $warnings = null, $resResponseType = null)
    {
        $this
            ->setPOS($pOS)
            ->setUnitReservations($unitReservations)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get POS value
     * @return \rdyescapia\ArrayType\ArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \rdyescapia\ArrayType\ArrayOfSourceType $pOS
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setPOS(\rdyescapia\ArrayType\ArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapia\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return isset($this->UnitReservations) ? $this->UnitReservations : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUnitReservations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitReservations method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUnitReservationsForChoiceConstraintsFromSetUnitReservations($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Errors',
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UnitReservations can\'t be set as the property %s is already set. Only one property must be set among these properties: UnitReservations, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UnitReservations value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setUnitReservations(\rdyescapia\StructType\UnitReservationsType $unitReservations = null)
    {
        // validation for constraint: choice(UnitReservations, Errors, Success, Warnings)
        if ('' !== ($unitReservationsChoiceErrorMessage = self::validateUnitReservationsForChoiceConstraintsFromSetUnitReservations($unitReservations))) {
            throw new \InvalidArgumentException($unitReservationsChoiceErrorMessage, __LINE__);
        }
        if (is_null($unitReservations) || (is_array($unitReservations) && empty($unitReservations))) {
            unset($this->UnitReservations);
        } else {
            $this->UnitReservations = $unitReservations;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \rdyescapia\StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UnitReservations',
            'Success',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ErrorsType $errors
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setErrors(\rdyescapia\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(UnitReservations, Errors, Success, Warnings)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return \rdyescapia\StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UnitReservations',
            'Errors',
            'Warnings',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SuccessType $success
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setSuccess(\rdyescapia\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(UnitReservations, Errors, Success, Warnings)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \rdyescapia\StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UnitReservations',
            'Errors',
            'Success',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\WarningsType $warnings
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setWarnings(\rdyescapia\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(UnitReservations, Errors, Success, Warnings)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \rdyescapia\EnumType\TransactionStatusType::valueIsValid()
     * @uses \rdyescapia\EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\TransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\TransactionStatusType', is_array($resResponseType) ? implode(', ', $resResponseType) : var_export($resResponseType, true), implode(', ', \rdyescapia\EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
