<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitInfoType StructType
 * @subpackage Structs
 */
class UnitInfoType extends AbstractStructBase
{
    /**
     * The UnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitName
     */
    public $UnitName;
    /**
     * The CategoryCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EVRN_CategoryCodesType
     */
    public $CategoryCodes;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Descriptions
     */
    public $Descriptions;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Position
     */
    public $Position;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfUnitInfoTypeService
     */
    public $Services;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressType
     */
    public $Address;
    /**
     * The UnitAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitAmenityType[]
     */
    public $UnitAmenity;
    /**
     * The RateRanges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfRateRangeType
     */
    public $RateRanges;
    /**
     * The Distribution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DistributionType
     */
    public $Distribution;
    /**
     * The AreaSquareFeet
     * @var float
     */
    public $AreaSquareFeet;
    /**
     * The MaxOccupancy
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The NumberFloors
     * @var int
     */
    public $NumberFloors;
    /**
     * The WhenBuilt
     * @var string
     */
    public $WhenBuilt;
    /**
     * The LastUpdated
     * @var string
     */
    public $LastUpdated;
    /**
     * The MunicipalityLicenseNumber
     * @var string
     */
    public $MunicipalityLicenseNumber;
    /**
     * The VirtualTourURL
     * @var string
     */
    public $VirtualTourURL;
    /**
     * Constructor method for UnitInfoType
     * @uses UnitInfoType::setUnitName()
     * @uses UnitInfoType::setCategoryCodes()
     * @uses UnitInfoType::setDescriptions()
     * @uses UnitInfoType::setPosition()
     * @uses UnitInfoType::setServices()
     * @uses UnitInfoType::setAddress()
     * @uses UnitInfoType::setUnitAmenity()
     * @uses UnitInfoType::setRateRanges()
     * @uses UnitInfoType::setDistribution()
     * @uses UnitInfoType::setAreaSquareFeet()
     * @uses UnitInfoType::setMaxOccupancy()
     * @uses UnitInfoType::setNumberFloors()
     * @uses UnitInfoType::setWhenBuilt()
     * @uses UnitInfoType::setLastUpdated()
     * @uses UnitInfoType::setMunicipalityLicenseNumber()
     * @uses UnitInfoType::setVirtualTourURL()
     * @param \rdyescapia\StructType\UnitName $unitName
     * @param \rdyescapia\StructType\EVRN_CategoryCodesType $categoryCodes
     * @param \rdyescapia\StructType\Descriptions $descriptions
     * @param \rdyescapia\StructType\Position $position
     * @param \rdyescapia\ArrayType\ArrayOfUnitInfoTypeService $services
     * @param \rdyescapia\StructType\AddressType $address
     * @param \rdyescapia\StructType\UnitAmenityType[] $unitAmenity
     * @param \rdyescapia\ArrayType\ArrayOfRateRangeType $rateRanges
     * @param \rdyescapia\StructType\DistributionType $distribution
     * @param float $areaSquareFeet
     * @param int $maxOccupancy
     * @param int $numberFloors
     * @param string $whenBuilt
     * @param string $lastUpdated
     * @param string $municipalityLicenseNumber
     * @param string $virtualTourURL
     */
    public function __construct(\rdyescapia\StructType\UnitName $unitName = null, \rdyescapia\StructType\EVRN_CategoryCodesType $categoryCodes = null, \rdyescapia\StructType\Descriptions $descriptions = null, \rdyescapia\StructType\Position $position = null, \rdyescapia\ArrayType\ArrayOfUnitInfoTypeService $services = null, \rdyescapia\StructType\AddressType $address = null, array $unitAmenity = array(), \rdyescapia\ArrayType\ArrayOfRateRangeType $rateRanges = null, \rdyescapia\StructType\DistributionType $distribution = null, $areaSquareFeet = null, $maxOccupancy = null, $numberFloors = null, $whenBuilt = null, $lastUpdated = null, $municipalityLicenseNumber = null, $virtualTourURL = null)
    {
        $this
            ->setUnitName($unitName)
            ->setCategoryCodes($categoryCodes)
            ->setDescriptions($descriptions)
            ->setPosition($position)
            ->setServices($services)
            ->setAddress($address)
            ->setUnitAmenity($unitAmenity)
            ->setRateRanges($rateRanges)
            ->setDistribution($distribution)
            ->setAreaSquareFeet($areaSquareFeet)
            ->setMaxOccupancy($maxOccupancy)
            ->setNumberFloors($numberFloors)
            ->setWhenBuilt($whenBuilt)
            ->setLastUpdated($lastUpdated)
            ->setMunicipalityLicenseNumber($municipalityLicenseNumber)
            ->setVirtualTourURL($virtualTourURL);
    }
    /**
     * Get UnitName value
     * @return \rdyescapia\StructType\UnitName|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param \rdyescapia\StructType\UnitName $unitName
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setUnitName(\rdyescapia\StructType\UnitName $unitName = null)
    {
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get CategoryCodes value
     * @return \rdyescapia\StructType\EVRN_CategoryCodesType|null
     */
    public function getCategoryCodes()
    {
        return $this->CategoryCodes;
    }
    /**
     * Set CategoryCodes value
     * @param \rdyescapia\StructType\EVRN_CategoryCodesType $categoryCodes
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setCategoryCodes(\rdyescapia\StructType\EVRN_CategoryCodesType $categoryCodes = null)
    {
        $this->CategoryCodes = $categoryCodes;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \rdyescapia\StructType\Descriptions|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \rdyescapia\StructType\Descriptions $descriptions
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setDescriptions(\rdyescapia\StructType\Descriptions $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Position value
     * @return \rdyescapia\StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \rdyescapia\StructType\Position $position
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setPosition(\rdyescapia\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Services value
     * @return \rdyescapia\ArrayType\ArrayOfUnitInfoTypeService|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \rdyescapia\ArrayType\ArrayOfUnitInfoTypeService $services
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setServices(\rdyescapia\ArrayType\ArrayOfUnitInfoTypeService $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapia\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \rdyescapia\StructType\AddressType $address
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setAddress(\rdyescapia\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get UnitAmenity value
     * @return \rdyescapia\StructType\UnitAmenityType[]|null
     */
    public function getUnitAmenity()
    {
        return $this->UnitAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitAmenityForArrayConstraintsFromSetUnitAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitInfoTypeUnitAmenityItem) {
            // validation for constraint: itemType
            if (!$unitInfoTypeUnitAmenityItem instanceof \rdyescapia\StructType\UnitAmenityType) {
                $invalidValues[] = is_object($unitInfoTypeUnitAmenityItem) ? get_class($unitInfoTypeUnitAmenityItem) : sprintf('%s(%s)', gettype($unitInfoTypeUnitAmenityItem), var_export($unitInfoTypeUnitAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitAmenity property can only contain items of type \rdyescapia\StructType\UnitAmenityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitAmenityType[] $unitAmenity
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setUnitAmenity(array $unitAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($unitAmenityArrayErrorMessage = self::validateUnitAmenityForArrayConstraintsFromSetUnitAmenity($unitAmenity))) {
            throw new \InvalidArgumentException($unitAmenityArrayErrorMessage, __LINE__);
        }
        $this->UnitAmenity = $unitAmenity;
        return $this;
    }
    /**
     * Add item to UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitAmenityType $item
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function addToUnitAmenity(\rdyescapia\StructType\UnitAmenityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitAmenityType) {
            throw new \InvalidArgumentException(sprintf('The UnitAmenity property can only contain items of type \rdyescapia\StructType\UnitAmenityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitAmenity[] = $item;
        return $this;
    }
    /**
     * Get RateRanges value
     * @return \rdyescapia\ArrayType\ArrayOfRateRangeType|null
     */
    public function getRateRanges()
    {
        return $this->RateRanges;
    }
    /**
     * Set RateRanges value
     * @param \rdyescapia\ArrayType\ArrayOfRateRangeType $rateRanges
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setRateRanges(\rdyescapia\ArrayType\ArrayOfRateRangeType $rateRanges = null)
    {
        $this->RateRanges = $rateRanges;
        return $this;
    }
    /**
     * Get Distribution value
     * @return \rdyescapia\StructType\DistributionType|null
     */
    public function getDistribution()
    {
        return $this->Distribution;
    }
    /**
     * Set Distribution value
     * @param \rdyescapia\StructType\DistributionType $distribution
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setDistribution(\rdyescapia\StructType\DistributionType $distribution = null)
    {
        $this->Distribution = $distribution;
        return $this;
    }
    /**
     * Get AreaSquareFeet value
     * @return float|null
     */
    public function getAreaSquareFeet()
    {
        return $this->AreaSquareFeet;
    }
    /**
     * Set AreaSquareFeet value
     * @param float $areaSquareFeet
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setAreaSquareFeet($areaSquareFeet = null)
    {
        // validation for constraint: float
        if (!is_null($areaSquareFeet) && !(is_float($areaSquareFeet) || is_numeric($areaSquareFeet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($areaSquareFeet, true), gettype($areaSquareFeet)), __LINE__);
        }
        $this->AreaSquareFeet = $areaSquareFeet;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get NumberFloors value
     * @return int|null
     */
    public function getNumberFloors()
    {
        return $this->NumberFloors;
    }
    /**
     * Set NumberFloors value
     * @param int $numberFloors
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setNumberFloors($numberFloors = null)
    {
        // validation for constraint: int
        if (!is_null($numberFloors) && !(is_int($numberFloors) || ctype_digit($numberFloors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberFloors, true), gettype($numberFloors)), __LINE__);
        }
        $this->NumberFloors = $numberFloors;
        return $this;
    }
    /**
     * Get WhenBuilt value
     * @return string|null
     */
    public function getWhenBuilt()
    {
        return $this->WhenBuilt;
    }
    /**
     * Set WhenBuilt value
     * @param string $whenBuilt
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setWhenBuilt($whenBuilt = null)
    {
        // validation for constraint: string
        if (!is_null($whenBuilt) && !is_string($whenBuilt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whenBuilt, true), gettype($whenBuilt)), __LINE__);
        }
        $this->WhenBuilt = $whenBuilt;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get MunicipalityLicenseNumber value
     * @return string|null
     */
    public function getMunicipalityLicenseNumber()
    {
        return $this->MunicipalityLicenseNumber;
    }
    /**
     * Set MunicipalityLicenseNumber value
     * @param string $municipalityLicenseNumber
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setMunicipalityLicenseNumber($municipalityLicenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($municipalityLicenseNumber) && !is_string($municipalityLicenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipalityLicenseNumber, true), gettype($municipalityLicenseNumber)), __LINE__);
        }
        $this->MunicipalityLicenseNumber = $municipalityLicenseNumber;
        return $this;
    }
    /**
     * Get VirtualTourURL value
     * @return string|null
     */
    public function getVirtualTourURL()
    {
        return $this->VirtualTourURL;
    }
    /**
     * Set VirtualTourURL value
     * @param string $virtualTourURL
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public function setVirtualTourURL($virtualTourURL = null)
    {
        // validation for constraint: string
        if (!is_null($virtualTourURL) && !is_string($virtualTourURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($virtualTourURL, true), gettype($virtualTourURL)), __LINE__);
        }
        $this->VirtualTourURL = $virtualTourURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
