<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyInfo StructType
 * @subpackage Structs
 */
class PolicyInfo extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ParagraphType
     */
    public $Description;
    /**
     * The CheckInTime
     * @var string
     */
    public $CheckInTime;
    /**
     * The CheckOutTime
     * @var string
     */
    public $CheckOutTime;
    /**
     * The SmokingAllowed
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The TotalGuestCount
     * @var int
     */
    public $TotalGuestCount;
    /**
     * The MinimumAge
     * @var string
     */
    public $MinimumAge;
    /**
     * Constructor method for PolicyInfo
     * @uses PolicyInfo::setDescription()
     * @uses PolicyInfo::setCheckInTime()
     * @uses PolicyInfo::setCheckOutTime()
     * @uses PolicyInfo::setSmokingAllowed()
     * @uses PolicyInfo::setTotalGuestCount()
     * @uses PolicyInfo::setMinimumAge()
     * @param \rdyescapia\StructType\ParagraphType $description
     * @param string $checkInTime
     * @param string $checkOutTime
     * @param bool $smokingAllowed
     * @param int $totalGuestCount
     * @param string $minimumAge
     */
    public function __construct(\rdyescapia\StructType\ParagraphType $description = null, $checkInTime = null, $checkOutTime = null, $smokingAllowed = false, $totalGuestCount = null, $minimumAge = null)
    {
        $this
            ->setDescription($description)
            ->setCheckInTime($checkInTime)
            ->setCheckOutTime($checkOutTime)
            ->setSmokingAllowed($smokingAllowed)
            ->setTotalGuestCount($totalGuestCount)
            ->setMinimumAge($minimumAge);
    }
    /**
     * Get Description value
     * @return \rdyescapia\StructType\ParagraphType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \rdyescapia\StructType\ParagraphType $description
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public function setDescription(\rdyescapia\StructType\ParagraphType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CheckInTime value
     * @return string|null
     */
    public function getCheckInTime()
    {
        return $this->CheckInTime;
    }
    /**
     * Set CheckInTime value
     * @param string $checkInTime
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public function setCheckInTime($checkInTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkInTime) && !is_string($checkInTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInTime, true), gettype($checkInTime)), __LINE__);
        }
        $this->CheckInTime = $checkInTime;
        return $this;
    }
    /**
     * Get CheckOutTime value
     * @return string|null
     */
    public function getCheckOutTime()
    {
        return $this->CheckOutTime;
    }
    /**
     * Set CheckOutTime value
     * @param string $checkOutTime
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public function setCheckOutTime($checkOutTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutTime) && !is_string($checkOutTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutTime, true), gettype($checkOutTime)), __LINE__);
        }
        $this->CheckOutTime = $checkOutTime;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get TotalGuestCount value
     * @return int|null
     */
    public function getTotalGuestCount()
    {
        return $this->TotalGuestCount;
    }
    /**
     * Set TotalGuestCount value
     * @param int $totalGuestCount
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public function setTotalGuestCount($totalGuestCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalGuestCount) && !(is_int($totalGuestCount) || ctype_digit($totalGuestCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalGuestCount, true), gettype($totalGuestCount)), __LINE__);
        }
        $this->TotalGuestCount = $totalGuestCount;
        return $this;
    }
    /**
     * Get MinimumAge value
     * @return string|null
     */
    public function getMinimumAge()
    {
        return $this->MinimumAge;
    }
    /**
     * Set MinimumAge value
     * @param string $minimumAge
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public function setMinimumAge($minimumAge = null)
    {
        // validation for constraint: string
        if (!is_null($minimumAge) && !is_string($minimumAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumAge, true), gettype($minimumAge)), __LINE__);
        }
        $this->MinimumAge = $minimumAge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PolicyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
