<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealPrefType StructType
 * @subpackage Structs
 */
class MealPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The MealType
     * @var string
     */
    public $MealType;
    /**
     * The FavoriteFood
     * @var string
     */
    public $FavoriteFood;
    /**
     * The Beverage
     * @var string
     */
    public $Beverage;
    /**
     * Constructor method for MealPrefType
     * @uses MealPrefType::set_()
     * @uses MealPrefType::setPreferLevel()
     * @uses MealPrefType::setMealType()
     * @uses MealPrefType::setFavoriteFood()
     * @uses MealPrefType::setBeverage()
     * @param string $_
     * @param string $preferLevel
     * @param string $mealType
     * @param string $favoriteFood
     * @param string $beverage
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $mealType = null, $favoriteFood = null, $beverage = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setMealType($mealType)
            ->setFavoriteFood($favoriteFood)
            ->setBeverage($beverage);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \rdyescapia\StructType\MealPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\MealPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get MealType value
     * @return string|null
     */
    public function getMealType()
    {
        return $this->MealType;
    }
    /**
     * Set MealType value
     * @uses \rdyescapia\EnumType\MealType::valueIsValid()
     * @uses \rdyescapia\EnumType\MealType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mealType
     * @return \rdyescapia\StructType\MealPrefType
     */
    public function setMealType($mealType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\MealType::valueIsValid($mealType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\MealType', is_array($mealType) ? implode(', ', $mealType) : var_export($mealType, true), implode(', ', \rdyescapia\EnumType\MealType::getValidValues())), __LINE__);
        }
        $this->MealType = $mealType;
        return $this;
    }
    /**
     * Get FavoriteFood value
     * @return string|null
     */
    public function getFavoriteFood()
    {
        return $this->FavoriteFood;
    }
    /**
     * Set FavoriteFood value
     * @param string $favoriteFood
     * @return \rdyescapia\StructType\MealPrefType
     */
    public function setFavoriteFood($favoriteFood = null)
    {
        // validation for constraint: string
        if (!is_null($favoriteFood) && !is_string($favoriteFood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($favoriteFood, true), gettype($favoriteFood)), __LINE__);
        }
        $this->FavoriteFood = $favoriteFood;
        return $this;
    }
    /**
     * Get Beverage value
     * @return string|null
     */
    public function getBeverage()
    {
        return $this->Beverage;
    }
    /**
     * Set Beverage value
     * @param string $beverage
     * @return \rdyescapia\StructType\MealPrefType
     */
    public function setBeverage($beverage = null)
    {
        // validation for constraint: string
        if (!is_null($beverage) && !is_string($beverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beverage, true), gettype($beverage)), __LINE__);
        }
        $this->Beverage = $beverage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\MealPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
