<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_UnitHoldRQ StructType
 * @subpackage Structs
 */
class EVRN_UnitHoldRQ extends EVRN_BaseRQType
{
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The HoldType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HoldType;
    /**
     * The HoldID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HoldID;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The ReleaseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReleaseDate;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The HoldNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HoldNumber;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The RequestType
     * @var string
     */
    public $RequestType;
    /**
     * Constructor method for EVRN_UnitHoldRQ
     * @uses EVRN_UnitHoldRQ::setUnitCode()
     * @uses EVRN_UnitHoldRQ::setHoldType()
     * @uses EVRN_UnitHoldRQ::setHoldID()
     * @uses EVRN_UnitHoldRQ::setStartDate()
     * @uses EVRN_UnitHoldRQ::setEndDate()
     * @uses EVRN_UnitHoldRQ::setReleaseDate()
     * @uses EVRN_UnitHoldRQ::setFirstName()
     * @uses EVRN_UnitHoldRQ::setLastName()
     * @uses EVRN_UnitHoldRQ::setEmail()
     * @uses EVRN_UnitHoldRQ::setHoldNumber()
     * @uses EVRN_UnitHoldRQ::setPhoneNumber()
     * @uses EVRN_UnitHoldRQ::setNotes()
     * @uses EVRN_UnitHoldRQ::setRequestType()
     * @param string $unitCode
     * @param string $holdType
     * @param int $holdID
     * @param string $startDate
     * @param string $endDate
     * @param string $releaseDate
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     * @param string $holdNumber
     * @param string $phoneNumber
     * @param string $notes
     * @param string $requestType
     */
    public function __construct($unitCode = null, $holdType = null, $holdID = null, $startDate = null, $endDate = null, $releaseDate = null, $firstName = null, $lastName = null, $email = null, $holdNumber = null, $phoneNumber = null, $notes = null, $requestType = null)
    {
        $this
            ->setUnitCode($unitCode)
            ->setHoldType($holdType)
            ->setHoldID($holdID)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setReleaseDate($releaseDate)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setHoldNumber($holdNumber)
            ->setPhoneNumber($phoneNumber)
            ->setNotes($notes)
            ->setRequestType($requestType);
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get HoldType value
     * @return string|null
     */
    public function getHoldType()
    {
        return $this->HoldType;
    }
    /**
     * Set HoldType value
     * @param string $holdType
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setHoldType($holdType = null)
    {
        // validation for constraint: string
        if (!is_null($holdType) && !is_string($holdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdType, true), gettype($holdType)), __LINE__);
        }
        $this->HoldType = $holdType;
        return $this;
    }
    /**
     * Get HoldID value
     * @return int|null
     */
    public function getHoldID()
    {
        return $this->HoldID;
    }
    /**
     * Set HoldID value
     * @param int $holdID
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setHoldID($holdID = null)
    {
        // validation for constraint: int
        if (!is_null($holdID) && !(is_int($holdID) || ctype_digit($holdID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holdID, true), gettype($holdID)), __LINE__);
        }
        $this->HoldID = $holdID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ReleaseDate value
     * @return string|null
     */
    public function getReleaseDate()
    {
        return $this->ReleaseDate;
    }
    /**
     * Set ReleaseDate value
     * @param string $releaseDate
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setReleaseDate($releaseDate = null)
    {
        // validation for constraint: string
        if (!is_null($releaseDate) && !is_string($releaseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($releaseDate, true), gettype($releaseDate)), __LINE__);
        }
        $this->ReleaseDate = $releaseDate;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get HoldNumber value
     * @return string|null
     */
    public function getHoldNumber()
    {
        return $this->HoldNumber;
    }
    /**
     * Set HoldNumber value
     * @param string $holdNumber
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setHoldNumber($holdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($holdNumber) && !is_string($holdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdNumber, true), gettype($holdNumber)), __LINE__);
        }
        $this->HoldNumber = $holdNumber;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @param string $requestType
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\EVRN_UnitHoldRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
