<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInfoType StructType
 * @subpackage Structs
 */
class CompanyInfoType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType[]
     */
    public $CompanyName;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressInfoType[]
     */
    public $AddressInfo;
    /**
     * The TelephoneInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TelephoneInfoType[]
     */
    public $TelephoneInfo;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmailType[]
     */
    public $Email;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\URL_Type[]
     */
    public $URL;
    /**
     * The BusinessLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressType[]
     */
    public $BusinessLocale;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * Constructor method for CompanyInfoType
     * @uses CompanyInfoType::setCompanyName()
     * @uses CompanyInfoType::setAddressInfo()
     * @uses CompanyInfoType::setTelephoneInfo()
     * @uses CompanyInfoType::setEmail()
     * @uses CompanyInfoType::setURL()
     * @uses CompanyInfoType::setBusinessLocale()
     * @uses CompanyInfoType::setPaymentForm()
     * @uses CompanyInfoType::setContactPerson()
     * @uses CompanyInfoType::setTravelArranger()
     * @uses CompanyInfoType::setLoyaltyProgram()
     * @param \rdyescapia\StructType\CompanyNameType[] $companyName
     * @param \rdyescapia\StructType\AddressInfoType[] $addressInfo
     * @param \rdyescapia\StructType\TelephoneInfoType[] $telephoneInfo
     * @param \rdyescapia\StructType\EmailType[] $email
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @param \rdyescapia\StructType\AddressType[] $businessLocale
     * @param \rdyescapia\StructType\PaymentFormType[] $paymentForm
     * @param \rdyescapia\StructType\ContactPersonType[] $contactPerson
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @param \rdyescapia\StructType\LoyaltyProgramType[] $loyaltyProgram
     */
    public function __construct(array $companyName = array(), array $addressInfo = array(), array $telephoneInfo = array(), array $email = array(), array $uRL = array(), array $businessLocale = array(), array $paymentForm = array(), array $contactPerson = array(), array $travelArranger = array(), array $loyaltyProgram = array())
    {
        $this
            ->setCompanyName($companyName)
            ->setAddressInfo($addressInfo)
            ->setTelephoneInfo($telephoneInfo)
            ->setEmail($email)
            ->setURL($uRL)
            ->setBusinessLocale($businessLocale)
            ->setPaymentForm($paymentForm)
            ->setContactPerson($contactPerson)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram);
    }
    /**
     * Get CompanyName value
     * @return \rdyescapia\StructType\CompanyNameType[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyNameForArrayConstraintsFromSetCompanyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeCompanyNameItem instanceof \rdyescapia\StructType\CompanyNameType) {
                $invalidValues[] = is_object($companyInfoTypeCompanyNameItem) ? get_class($companyInfoTypeCompanyNameItem) : sprintf('%s(%s)', gettype($companyInfoTypeCompanyNameItem), var_export($companyInfoTypeCompanyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompanyName property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType[] $companyName
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setCompanyName(array $companyName = array())
    {
        // validation for constraint: array
        if ('' !== ($companyNameArrayErrorMessage = self::validateCompanyNameForArrayConstraintsFromSetCompanyName($companyName))) {
            throw new \InvalidArgumentException($companyNameArrayErrorMessage, __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNameType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToCompanyName(\rdyescapia\StructType\CompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of type \rdyescapia\StructType\CompanyNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \rdyescapia\StructType\AddressInfoType[]|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressInfoForArrayConstraintsFromSetAddressInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeAddressInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeAddressInfoItem instanceof \rdyescapia\StructType\AddressInfoType) {
                $invalidValues[] = is_object($companyInfoTypeAddressInfoItem) ? get_class($companyInfoTypeAddressInfoItem) : sprintf('%s(%s)', gettype($companyInfoTypeAddressInfoItem), var_export($companyInfoTypeAddressInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressInfo property can only contain items of type \rdyescapia\StructType\AddressInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressInfoType[] $addressInfo
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setAddressInfo(array $addressInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($addressInfoArrayErrorMessage = self::validateAddressInfoForArrayConstraintsFromSetAddressInfo($addressInfo))) {
            throw new \InvalidArgumentException($addressInfoArrayErrorMessage, __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Add item to AddressInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressInfoType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToAddressInfo(\rdyescapia\StructType\AddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The AddressInfo property can only contain items of type \rdyescapia\StructType\AddressInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressInfo[] = $item;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \rdyescapia\StructType\TelephoneInfoType[]|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephoneInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephoneInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneInfoForArrayConstraintsFromSetTelephoneInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTelephoneInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTelephoneInfoItem instanceof \rdyescapia\StructType\TelephoneInfoType) {
                $invalidValues[] = is_object($companyInfoTypeTelephoneInfoItem) ? get_class($companyInfoTypeTelephoneInfoItem) : sprintf('%s(%s)', gettype($companyInfoTypeTelephoneInfoItem), var_export($companyInfoTypeTelephoneInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TelephoneInfo property can only contain items of type \rdyescapia\StructType\TelephoneInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TelephoneInfoType[] $telephoneInfo
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setTelephoneInfo(array $telephoneInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneInfoArrayErrorMessage = self::validateTelephoneInfoForArrayConstraintsFromSetTelephoneInfo($telephoneInfo))) {
            throw new \InvalidArgumentException($telephoneInfoArrayErrorMessage, __LINE__);
        }
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Add item to TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TelephoneInfoType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToTelephoneInfo(\rdyescapia\StructType\TelephoneInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TelephoneInfoType) {
            throw new \InvalidArgumentException(sprintf('The TelephoneInfo property can only contain items of type \rdyescapia\StructType\TelephoneInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TelephoneInfo[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapia\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeEmailItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeEmailItem instanceof \rdyescapia\StructType\EmailType) {
                $invalidValues[] = is_object($companyInfoTypeEmailItem) ? get_class($companyInfoTypeEmailItem) : sprintf('%s(%s)', gettype($companyInfoTypeEmailItem), var_export($companyInfoTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \rdyescapia\StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType[] $email
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToEmail(\rdyescapia\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \rdyescapia\StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \rdyescapia\StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeURLItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeURLItem instanceof \rdyescapia\StructType\URL_Type) {
                $invalidValues[] = is_object($companyInfoTypeURLItem) ? get_class($companyInfoTypeURLItem) : sprintf('%s(%s)', gettype($companyInfoTypeURLItem), var_export($companyInfoTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \rdyescapia\StructType\URL_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToURL(\rdyescapia\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \rdyescapia\StructType\URL_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get BusinessLocale value
     * @return \rdyescapia\StructType\AddressType[]|null
     */
    public function getBusinessLocale()
    {
        return $this->BusinessLocale;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessLocale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessLocale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessLocaleForArrayConstraintsFromSetBusinessLocale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeBusinessLocaleItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeBusinessLocaleItem instanceof \rdyescapia\StructType\AddressType) {
                $invalidValues[] = is_object($companyInfoTypeBusinessLocaleItem) ? get_class($companyInfoTypeBusinessLocaleItem) : sprintf('%s(%s)', gettype($companyInfoTypeBusinessLocaleItem), var_export($companyInfoTypeBusinessLocaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessLocale property can only contain items of type \rdyescapia\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessLocale value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressType[] $businessLocale
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setBusinessLocale(array $businessLocale = array())
    {
        // validation for constraint: array
        if ('' !== ($businessLocaleArrayErrorMessage = self::validateBusinessLocaleForArrayConstraintsFromSetBusinessLocale($businessLocale))) {
            throw new \InvalidArgumentException($businessLocaleArrayErrorMessage, __LINE__);
        }
        $this->BusinessLocale = $businessLocale;
        return $this;
    }
    /**
     * Add item to BusinessLocale value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AddressType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToBusinessLocale(\rdyescapia\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The BusinessLocale property can only contain items of type \rdyescapia\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessLocale[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \rdyescapia\StructType\PaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypePaymentFormItem instanceof \rdyescapia\StructType\PaymentFormType) {
                $invalidValues[] = is_object($companyInfoTypePaymentFormItem) ? get_class($companyInfoTypePaymentFormItem) : sprintf('%s(%s)', gettype($companyInfoTypePaymentFormItem), var_export($companyInfoTypePaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \rdyescapia\StructType\PaymentFormType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormType[] $paymentForm
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToPaymentForm(\rdyescapia\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \rdyescapia\StructType\PaymentFormType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \rdyescapia\StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeContactPersonItem instanceof \rdyescapia\StructType\ContactPersonType) {
                $invalidValues[] = is_object($companyInfoTypeContactPersonItem) ? get_class($companyInfoTypeContactPersonItem) : sprintf('%s(%s)', gettype($companyInfoTypeContactPersonItem), var_export($companyInfoTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type \rdyescapia\StructType\ContactPersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ContactPersonType[] $contactPerson
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ContactPersonType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToContactPerson(\rdyescapia\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type \rdyescapia\StructType\ContactPersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapia\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTravelArrangerItem instanceof \rdyescapia\StructType\TravelArrangerType) {
                $invalidValues[] = is_object($companyInfoTypeTravelArrangerItem) ? get_class($companyInfoTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($companyInfoTypeTravelArrangerItem), var_export($companyInfoTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type \rdyescapia\StructType\TravelArrangerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToTravelArranger(\rdyescapia\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type \rdyescapia\StructType\TravelArrangerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \rdyescapia\StructType\LoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeLoyaltyProgramItem instanceof \rdyescapia\StructType\LoyaltyProgramType) {
                $invalidValues[] = is_object($companyInfoTypeLoyaltyProgramItem) ? get_class($companyInfoTypeLoyaltyProgramItem) : sprintf('%s(%s)', gettype($companyInfoTypeLoyaltyProgramItem), var_export($companyInfoTypeLoyaltyProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgram property can only contain items of type \rdyescapia\StructType\LoyaltyProgramType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyProgramType[] $loyaltyProgram
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramArrayErrorMessage = self::validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram($loyaltyProgram))) {
            throw new \InvalidArgumentException($loyaltyProgramArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyProgramType $item
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public function addToLoyaltyProgram(\rdyescapia\StructType\LoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\LoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of type \rdyescapia\StructType\LoyaltyProgramType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CompanyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
