<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStay StructType
 * @subpackage Structs
 */
class UnitStay extends UnitStayType
{
    /**
     * The ResGuestRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH
     */
    public $ResGuestRPHs;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The ServiceRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Reference
     */
    public $Reference;
    /**
     * The OverriddenUnitRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\OverriddenUnitStayRateType
     */
    public $OverriddenUnitRates;
    /**
     * The IndexNumber
     * @var int
     */
    public $IndexNumber;
    /**
     * The UnitRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The StayDateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The DepositPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DepositPayments
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CancelPenalties
     */
    public $CancelPenalties;
    /**
     * The BasicUnitInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\BasicUnitInfo
     */
    public $BasicUnitInfo;
    /**
     * The RentalAgreement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\RentalAgreement
     */
    public $RentalAgreement;
    /**
     * The Pets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetsPoliciesType
     */
    public $Pets;
    /**
     * The AdditionalCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AdditionalCharges
     */
    public $AdditionalCharges;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DiscountType
     */
    public $Discount;
    /**
     * The AvailableOnlyIndicator
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * The SourceCategory
     * @var string
     */
    public $SourceCategory;
    /**
     * The SourceSubCategory
     * @var string
     */
    public $SourceSubCategory;
    /**
     * Constructor method for UnitStay
     * @uses UnitStay::setResGuestRPHs()
     * @uses UnitStay::setComments()
     * @uses UnitStay::setSpecialRequests()
     * @uses UnitStay::setServiceRPHs()
     * @uses UnitStay::setReference()
     * @uses UnitStay::setOverriddenUnitRates()
     * @uses UnitStay::setIndexNumber()
     * @uses UnitStay::setUnitRef()
     * @uses UnitStay::setStayDateRange()
     * @uses UnitStay::setGuestCounts()
     * @uses UnitStay::setDepositPayments()
     * @uses UnitStay::setCancelPenalties()
     * @uses UnitStay::setBasicUnitInfo()
     * @uses UnitStay::setRentalAgreement()
     * @uses UnitStay::setPets()
     * @uses UnitStay::setAdditionalCharges()
     * @uses UnitStay::setDiscount()
     * @uses UnitStay::setAvailableOnlyIndicator()
     * @uses UnitStay::setPromotionCode()
     * @uses UnitStay::setSourceCategory()
     * @uses UnitStay::setSourceSubCategory()
     * @param \rdyescapia\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @param \rdyescapia\ArrayType\ArrayOfCommentTypeComment $comments
     * @param \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param \rdyescapia\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param \rdyescapia\StructType\Reference $reference
     * @param \rdyescapia\StructType\OverriddenUnitStayRateType $overriddenUnitRates
     * @param int $indexNumber
     * @param \rdyescapia\StructType\UnitRef $unitRef
     * @param \rdyescapia\StructType\DateTimeSpanType $stayDateRange
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @param \rdyescapia\StructType\DepositPayments $depositPayments
     * @param \rdyescapia\StructType\CancelPenalties $cancelPenalties
     * @param \rdyescapia\StructType\BasicUnitInfo $basicUnitInfo
     * @param \rdyescapia\StructType\RentalAgreement $rentalAgreement
     * @param \rdyescapia\StructType\PetsPoliciesType $pets
     * @param \rdyescapia\StructType\AdditionalCharges $additionalCharges
     * @param \rdyescapia\StructType\DiscountType $discount
     * @param bool $availableOnlyIndicator
     * @param string $promotionCode
     * @param string $sourceCategory
     * @param string $sourceSubCategory
     */
    public function __construct(\rdyescapia\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null, \rdyescapia\ArrayType\ArrayOfCommentTypeComment $comments = null, \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, \rdyescapia\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, \rdyescapia\StructType\Reference $reference = null, \rdyescapia\StructType\OverriddenUnitStayRateType $overriddenUnitRates = null, $indexNumber = null, \rdyescapia\StructType\UnitRef $unitRef = null, \rdyescapia\StructType\DateTimeSpanType $stayDateRange = null, \rdyescapia\StructType\GuestCountType $guestCounts = null, \rdyescapia\StructType\DepositPayments $depositPayments = null, \rdyescapia\StructType\CancelPenalties $cancelPenalties = null, \rdyescapia\StructType\BasicUnitInfo $basicUnitInfo = null, \rdyescapia\StructType\RentalAgreement $rentalAgreement = null, \rdyescapia\StructType\PetsPoliciesType $pets = null, \rdyescapia\StructType\AdditionalCharges $additionalCharges = null, \rdyescapia\StructType\DiscountType $discount = null, $availableOnlyIndicator = null, $promotionCode = null, $sourceCategory = null, $sourceSubCategory = null)
    {
        $this
            ->setResGuestRPHs($resGuestRPHs)
            ->setComments($comments)
            ->setSpecialRequests($specialRequests)
            ->setServiceRPHs($serviceRPHs)
            ->setReference($reference)
            ->setOverriddenUnitRates($overriddenUnitRates)
            ->setIndexNumber($indexNumber)
            ->setUnitRef($unitRef)
            ->setStayDateRange($stayDateRange)
            ->setGuestCounts($guestCounts)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setBasicUnitInfo($basicUnitInfo)
            ->setRentalAgreement($rentalAgreement)
            ->setPets($pets)
            ->setAdditionalCharges($additionalCharges)
            ->setDiscount($discount)
            ->setAvailableOnlyIndicator($availableOnlyIndicator)
            ->setPromotionCode($promotionCode)
            ->setSourceCategory($sourceCategory)
            ->setSourceSubCategory($sourceSubCategory);
    }
    /**
     * Get ResGuestRPHs value
     * @return \rdyescapia\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \rdyescapia\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setResGuestRPHs(\rdyescapia\ArrayType\ArrayOfResGuestRPHsTypeResGuestRPH $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Comments value
     * @return \rdyescapia\ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \rdyescapia\ArrayType\ArrayOfCommentTypeComment $comments
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setComments(\rdyescapia\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setSpecialRequests(\rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \rdyescapia\ArrayType\ArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \rdyescapia\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setServiceRPHs(\rdyescapia\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get Reference value
     * @return \rdyescapia\StructType\Reference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \rdyescapia\StructType\Reference $reference
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setReference(\rdyescapia\StructType\Reference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get OverriddenUnitRates value
     * @return \rdyescapia\StructType\OverriddenUnitStayRateType|null
     */
    public function getOverriddenUnitRates()
    {
        return $this->OverriddenUnitRates;
    }
    /**
     * Set OverriddenUnitRates value
     * @param \rdyescapia\StructType\OverriddenUnitStayRateType $overriddenUnitRates
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setOverriddenUnitRates(\rdyescapia\StructType\OverriddenUnitStayRateType $overriddenUnitRates = null)
    {
        $this->OverriddenUnitRates = $overriddenUnitRates;
        return $this;
    }
    /**
     * Get IndexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !is_numeric($indexNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get UnitRef value
     * @return \rdyescapia\StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \rdyescapia\StructType\UnitRef $unitRef
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setUnitRef(\rdyescapia\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \rdyescapia\StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \rdyescapia\StructType\DateTimeSpanType $stayDateRange
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setStayDateRange(\rdyescapia\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapia\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setGuestCounts(\rdyescapia\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \rdyescapia\StructType\DepositPayments|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \rdyescapia\StructType\DepositPayments $depositPayments
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setDepositPayments(\rdyescapia\StructType\DepositPayments $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \rdyescapia\StructType\CancelPenalties|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \rdyescapia\StructType\CancelPenalties $cancelPenalties
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setCancelPenalties(\rdyescapia\StructType\CancelPenalties $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get BasicUnitInfo value
     * @return \rdyescapia\StructType\BasicUnitInfo|null
     */
    public function getBasicUnitInfo()
    {
        return $this->BasicUnitInfo;
    }
    /**
     * Set BasicUnitInfo value
     * @param \rdyescapia\StructType\BasicUnitInfo $basicUnitInfo
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setBasicUnitInfo(\rdyescapia\StructType\BasicUnitInfo $basicUnitInfo = null)
    {
        $this->BasicUnitInfo = $basicUnitInfo;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \rdyescapia\StructType\RentalAgreement|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \rdyescapia\StructType\RentalAgreement $rentalAgreement
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setRentalAgreement(\rdyescapia\StructType\RentalAgreement $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get Pets value
     * @return \rdyescapia\StructType\PetsPoliciesType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \rdyescapia\StructType\PetsPoliciesType $pets
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setPets(\rdyescapia\StructType\PetsPoliciesType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get AdditionalCharges value
     * @return \rdyescapia\StructType\AdditionalCharges|null
     */
    public function getAdditionalCharges()
    {
        return $this->AdditionalCharges;
    }
    /**
     * Set AdditionalCharges value
     * @param \rdyescapia\StructType\AdditionalCharges $additionalCharges
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setAdditionalCharges(\rdyescapia\StructType\AdditionalCharges $additionalCharges = null)
    {
        $this->AdditionalCharges = $additionalCharges;
        return $this;
    }
    /**
     * Get Discount value
     * @return \rdyescapia\StructType\DiscountType|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \rdyescapia\StructType\DiscountType $discount
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setDiscount(\rdyescapia\StructType\DiscountType $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get SourceCategory value
     * @return string|null
     */
    public function getSourceCategory()
    {
        return $this->SourceCategory;
    }
    /**
     * Set SourceCategory value
     * @param string $sourceCategory
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setSourceCategory($sourceCategory = null)
    {
        // validation for constraint: string
        if (!is_null($sourceCategory) && !is_string($sourceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceCategory)), __LINE__);
        }
        $this->SourceCategory = $sourceCategory;
        return $this;
    }
    /**
     * Get SourceSubCategory value
     * @return string|null
     */
    public function getSourceSubCategory()
    {
        return $this->SourceSubCategory;
    }
    /**
     * Set SourceSubCategory value
     * @param string $sourceSubCategory
     * @return \rdyescapia\StructType\UnitStay
     */
    public function setSourceSubCategory($sourceSubCategory = null)
    {
        // validation for constraint: string
        if (!is_null($sourceSubCategory) && !is_string($sourceSubCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceSubCategory)), __LINE__);
        }
        $this->SourceSubCategory = $sourceSubCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
