<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitSearchCriteriaType StructType
 * @subpackage Structs
 */
class UnitSearchCriteriaType extends AbstractStructBase
{
    /**
     * The Criterion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitSearchCriterionType[]
     */
    public $Criterion;
    /**
     * The AvailableOnlyIndicator
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * Constructor method for UnitSearchCriteriaType
     * @uses UnitSearchCriteriaType::setCriterion()
     * @uses UnitSearchCriteriaType::setAvailableOnlyIndicator()
     * @param \rdyescapia\StructType\UnitSearchCriterionType[] $criterion
     * @param bool $availableOnlyIndicator
     */
    public function __construct(array $criterion = array(), $availableOnlyIndicator = null)
    {
        $this
            ->setCriterion($criterion)
            ->setAvailableOnlyIndicator($availableOnlyIndicator);
    }
    /**
     * Get Criterion value
     * @return \rdyescapia\StructType\UnitSearchCriterionType[]|null
     */
    public function getCriterion()
    {
        return $this->Criterion;
    }
    /**
     * Set Criterion value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitSearchCriterionType[] $criterion
     * @return \rdyescapia\StructType\UnitSearchCriteriaType
     */
    public function setCriterion(array $criterion = array())
    {
        foreach ($criterion as $unitSearchCriteriaTypeCriterionItem) {
            // validation for constraint: itemType
            if (!$unitSearchCriteriaTypeCriterionItem instanceof \rdyescapia\StructType\UnitSearchCriterionType) {
                throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of \rdyescapia\StructType\UnitSearchCriterionType, "%s" given', is_object($unitSearchCriteriaTypeCriterionItem) ? get_class($unitSearchCriteriaTypeCriterionItem) : gettype($unitSearchCriteriaTypeCriterionItem)), __LINE__);
            }
        }
        $this->Criterion = $criterion;
        return $this;
    }
    /**
     * Add item to Criterion value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitSearchCriterionType $item
     * @return \rdyescapia\StructType\UnitSearchCriteriaType
     */
    public function addToCriterion(\rdyescapia\StructType\UnitSearchCriterionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitSearchCriterionType) {
            throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of \rdyescapia\StructType\UnitSearchCriterionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Criterion[] = $item;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \rdyescapia\StructType\UnitSearchCriteriaType
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitSearchCriteriaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
