<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveContents StructType
 * @subpackage Structs
 */
class UnitDescriptiveContents extends AbstractStructBase
{
    /**
     * The UnitDescriptiveContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitDescriptiveContentType[]
     */
    public $UnitDescriptiveContent;
    /**
     * The CachedData
     * @var bool
     */
    public $CachedData;
    /**
     * Constructor method for UnitDescriptiveContents
     * @uses UnitDescriptiveContents::setUnitDescriptiveContent()
     * @uses UnitDescriptiveContents::setCachedData()
     * @param \rdyescapia\StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @param bool $cachedData
     */
    public function __construct(array $unitDescriptiveContent = array(), $cachedData = null)
    {
        $this
            ->setUnitDescriptiveContent($unitDescriptiveContent)
            ->setCachedData($cachedData);
    }
    /**
     * Get UnitDescriptiveContent value
     * @return \rdyescapia\StructType\UnitDescriptiveContentType[]|null
     */
    public function getUnitDescriptiveContent()
    {
        return $this->UnitDescriptiveContent;
    }
    /**
     * Set UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public function setUnitDescriptiveContent(array $unitDescriptiveContent = array())
    {
        foreach ($unitDescriptiveContent as $unitDescriptiveContentsUnitDescriptiveContentItem) {
            // validation for constraint: itemType
            if (!$unitDescriptiveContentsUnitDescriptiveContentItem instanceof \rdyescapia\StructType\UnitDescriptiveContentType) {
                throw new \InvalidArgumentException(sprintf('The UnitDescriptiveContent property can only contain items of \rdyescapia\StructType\UnitDescriptiveContentType, "%s" given', is_object($unitDescriptiveContentsUnitDescriptiveContentItem) ? get_class($unitDescriptiveContentsUnitDescriptiveContentItem) : gettype($unitDescriptiveContentsUnitDescriptiveContentItem)), __LINE__);
            }
        }
        $this->UnitDescriptiveContent = $unitDescriptiveContent;
        return $this;
    }
    /**
     * Add item to UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitDescriptiveContentType $item
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public function addToUnitDescriptiveContent(\rdyescapia\StructType\UnitDescriptiveContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitDescriptiveContentType) {
            throw new \InvalidArgumentException(sprintf('The UnitDescriptiveContent property can only contain items of \rdyescapia\StructType\UnitDescriptiveContentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitDescriptiveContent[] = $item;
        return $this;
    }
    /**
     * Get CachedData value
     * @return bool|null
     */
    public function getCachedData()
    {
        return $this->CachedData;
    }
    /**
     * Set CachedData value
     * @param bool $cachedData
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public function setCachedData($cachedData = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedData) && !is_bool($cachedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cachedData)), __LINE__);
        }
        $this->CachedData = $cachedData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitDescriptiveContents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
