<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextItemsType StructType
 * @subpackage Structs
 */
class TextItemsType extends AbstractStructBase
{
    /**
     * The TextItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TextItem[]
     */
    public $TextItem;
    /**
     * The MoreData
     * @var bool
     */
    public $MoreData;
    /**
     * Constructor method for TextItemsType
     * @uses TextItemsType::setTextItem()
     * @uses TextItemsType::setMoreData()
     * @param \rdyescapia\StructType\TextItem[] $textItem
     * @param bool $moreData
     */
    public function __construct(array $textItem = array(), $moreData = null)
    {
        $this
            ->setTextItem($textItem)
            ->setMoreData($moreData);
    }
    /**
     * Get TextItem value
     * @return \rdyescapia\StructType\TextItem[]|null
     */
    public function getTextItem()
    {
        return $this->TextItem;
    }
    /**
     * Set TextItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TextItem[] $textItem
     * @return \rdyescapia\StructType\TextItemsType
     */
    public function setTextItem(array $textItem = array())
    {
        foreach ($textItem as $textItemsTypeTextItemItem) {
            // validation for constraint: itemType
            if (!$textItemsTypeTextItemItem instanceof \rdyescapia\StructType\TextItem) {
                throw new \InvalidArgumentException(sprintf('The TextItem property can only contain items of \rdyescapia\StructType\TextItem, "%s" given', is_object($textItemsTypeTextItemItem) ? get_class($textItemsTypeTextItemItem) : gettype($textItemsTypeTextItemItem)), __LINE__);
            }
        }
        $this->TextItem = $textItem;
        return $this;
    }
    /**
     * Add item to TextItem value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TextItem $item
     * @return \rdyescapia\StructType\TextItemsType
     */
    public function addToTextItem(\rdyescapia\StructType\TextItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TextItem) {
            throw new \InvalidArgumentException(sprintf('The TextItem property can only contain items of \rdyescapia\StructType\TextItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TextItem[] = $item;
        return $this;
    }
    /**
     * Get MoreData value
     * @return bool|null
     */
    public function getMoreData()
    {
        return $this->MoreData;
    }
    /**
     * Set MoreData value
     * @param bool $moreData
     * @return \rdyescapia\StructType\TextItemsType
     */
    public function setMoreData($moreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreData) && !is_bool($moreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreData)), __LINE__);
        }
        $this->MoreData = $moreData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\TextItemsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
