<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType StructType
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The TaxDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ParagraphType[]
     */
    public $TaxDescription;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The ChargeFrequency
     * @var string
     */
    public $ChargeFrequency;
    /**
     * The ChargeUnitExempt
     * @var int
     */
    public $ChargeUnitExempt;
    /**
     * The ChargeFrequencyExempt
     * @var int
     */
    public $ChargeFrequencyExempt;
    /**
     * The MaxChargeUnitApplies
     * @var int
     */
    public $MaxChargeUnitApplies;
    /**
     * The MaxChargeFrequencyApplies
     * @var int
     */
    public $MaxChargeFrequencyApplies;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setTaxDescription()
     * @uses TaxType::setType()
     * @uses TaxType::setCode()
     * @uses TaxType::setPercent()
     * @uses TaxType::setAmount()
     * @uses TaxType::setCurrencyCode()
     * @uses TaxType::setDecimalPlaces()
     * @uses TaxType::setEffectiveDate()
     * @uses TaxType::setExpireDate()
     * @uses TaxType::setChargeUnit()
     * @uses TaxType::setChargeFrequency()
     * @uses TaxType::setChargeUnitExempt()
     * @uses TaxType::setChargeFrequencyExempt()
     * @uses TaxType::setMaxChargeUnitApplies()
     * @uses TaxType::setMaxChargeFrequencyApplies()
     * @param \rdyescapia\StructType\ParagraphType[] $taxDescription
     * @param string $type
     * @param string $code
     * @param float $percent
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $chargeUnit
     * @param string $chargeFrequency
     * @param int $chargeUnitExempt
     * @param int $chargeFrequencyExempt
     * @param int $maxChargeUnitApplies
     * @param int $maxChargeFrequencyApplies
     */
    public function __construct(array $taxDescription = array(), $type = null, $code = null, $percent = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $effectiveDate = null, $expireDate = null, $chargeUnit = null, $chargeFrequency = null, $chargeUnitExempt = null, $chargeFrequencyExempt = null, $maxChargeUnitApplies = null, $maxChargeFrequencyApplies = null)
    {
        $this
            ->setTaxDescription($taxDescription)
            ->setType($type)
            ->setCode($code)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setChargeUnit($chargeUnit)
            ->setChargeFrequency($chargeFrequency)
            ->setChargeUnitExempt($chargeUnitExempt)
            ->setChargeFrequencyExempt($chargeFrequencyExempt)
            ->setMaxChargeUnitApplies($maxChargeUnitApplies)
            ->setMaxChargeFrequencyApplies($maxChargeFrequencyApplies);
    }
    /**
     * Get TaxDescription value
     * @return \rdyescapia\StructType\ParagraphType[]|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * Set TaxDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ParagraphType[] $taxDescription
     * @return \rdyescapia\StructType\TaxType
     */
    public function setTaxDescription(array $taxDescription = array())
    {
        foreach ($taxDescription as $taxTypeTaxDescriptionItem) {
            // validation for constraint: itemType
            if (!$taxTypeTaxDescriptionItem instanceof \rdyescapia\StructType\ParagraphType) {
                throw new \InvalidArgumentException(sprintf('The TaxDescription property can only contain items of \rdyescapia\StructType\ParagraphType, "%s" given', is_object($taxTypeTaxDescriptionItem) ? get_class($taxTypeTaxDescriptionItem) : gettype($taxTypeTaxDescriptionItem)), __LINE__);
            }
        }
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Add item to TaxDescription value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ParagraphType $item
     * @return \rdyescapia\StructType\TaxType
     */
    public function addToTaxDescription(\rdyescapia\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The TaxDescription property can only contain items of \rdyescapia\StructType\ParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaxDescription[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \rdyescapia\EnumType\AmountDeterminationType::valueIsValid()
     * @uses \rdyescapia\EnumType\AmountDeterminationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \rdyescapia\StructType\TaxType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\AmountDeterminationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \rdyescapia\EnumType\AmountDeterminationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \rdyescapia\StructType\TaxType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \rdyescapia\StructType\TaxType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \rdyescapia\StructType\TaxType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapia\StructType\TaxType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapia\StructType\TaxType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \rdyescapia\StructType\TaxType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \rdyescapia\StructType\TaxType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \rdyescapia\StructType\TaxType
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get ChargeFrequency value
     * @return string|null
     */
    public function getChargeFrequency()
    {
        return $this->ChargeFrequency;
    }
    /**
     * Set ChargeFrequency value
     * @param string $chargeFrequency
     * @return \rdyescapia\StructType\TaxType
     */
    public function setChargeFrequency($chargeFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($chargeFrequency) && !is_string($chargeFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeFrequency)), __LINE__);
        }
        $this->ChargeFrequency = $chargeFrequency;
        return $this;
    }
    /**
     * Get ChargeUnitExempt value
     * @return int|null
     */
    public function getChargeUnitExempt()
    {
        return $this->ChargeUnitExempt;
    }
    /**
     * Set ChargeUnitExempt value
     * @param int $chargeUnitExempt
     * @return \rdyescapia\StructType\TaxType
     */
    public function setChargeUnitExempt($chargeUnitExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeUnitExempt) && !is_numeric($chargeUnitExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeUnitExempt)), __LINE__);
        }
        $this->ChargeUnitExempt = $chargeUnitExempt;
        return $this;
    }
    /**
     * Get ChargeFrequencyExempt value
     * @return int|null
     */
    public function getChargeFrequencyExempt()
    {
        return $this->ChargeFrequencyExempt;
    }
    /**
     * Set ChargeFrequencyExempt value
     * @param int $chargeFrequencyExempt
     * @return \rdyescapia\StructType\TaxType
     */
    public function setChargeFrequencyExempt($chargeFrequencyExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeFrequencyExempt) && !is_numeric($chargeFrequencyExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeFrequencyExempt)), __LINE__);
        }
        $this->ChargeFrequencyExempt = $chargeFrequencyExempt;
        return $this;
    }
    /**
     * Get MaxChargeUnitApplies value
     * @return int|null
     */
    public function getMaxChargeUnitApplies()
    {
        return $this->MaxChargeUnitApplies;
    }
    /**
     * Set MaxChargeUnitApplies value
     * @param int $maxChargeUnitApplies
     * @return \rdyescapia\StructType\TaxType
     */
    public function setMaxChargeUnitApplies($maxChargeUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeUnitApplies) && !is_numeric($maxChargeUnitApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChargeUnitApplies)), __LINE__);
        }
        $this->MaxChargeUnitApplies = $maxChargeUnitApplies;
        return $this;
    }
    /**
     * Get MaxChargeFrequencyApplies value
     * @return int|null
     */
    public function getMaxChargeFrequencyApplies()
    {
        return $this->MaxChargeFrequencyApplies;
    }
    /**
     * Set MaxChargeFrequencyApplies value
     * @param int $maxChargeFrequencyApplies
     * @return \rdyescapia\StructType\TaxType
     */
    public function setMaxChargeFrequencyApplies($maxChargeFrequencyApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeFrequencyApplies) && !is_numeric($maxChargeFrequencyApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChargeFrequencyApplies)), __LINE__);
        }
        $this->MaxChargeFrequencyApplies = $maxChargeFrequencyApplies;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\TaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
