<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviewScoreType StructType
 * @subpackage Structs
 */
class ReviewScoreType extends AbstractStructBase
{
    /**
     * The Score
     * @var float
     */
    public $Score;
    /**
     * The CategoryID
     * @var int
     */
    public $CategoryID;
    /**
     * The CategoryName
     * @var string
     */
    public $CategoryName;
    /**
     * The CategoryType
     * @var string
     */
    public $CategoryType;
    /**
     * The SortOrder
     * @var int
     */
    public $SortOrder;
    /**
     * Constructor method for ReviewScoreType
     * @uses ReviewScoreType::setScore()
     * @uses ReviewScoreType::setCategoryID()
     * @uses ReviewScoreType::setCategoryName()
     * @uses ReviewScoreType::setCategoryType()
     * @uses ReviewScoreType::setSortOrder()
     * @param float $score
     * @param int $categoryID
     * @param string $categoryName
     * @param string $categoryType
     * @param int $sortOrder
     */
    public function __construct($score = null, $categoryID = null, $categoryName = null, $categoryType = null, $sortOrder = null)
    {
        $this
            ->setScore($score)
            ->setCategoryID($categoryID)
            ->setCategoryName($categoryName)
            ->setCategoryType($categoryType)
            ->setSortOrder($sortOrder);
    }
    /**
     * Get Score value
     * @return float|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param float $score
     * @return \rdyescapia\StructType\ReviewScoreType
     */
    public function setScore($score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \rdyescapia\StructType\ReviewScoreType
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \rdyescapia\StructType\ReviewScoreType
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param string $categoryType
     * @return \rdyescapia\StructType\ReviewScoreType
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: string
        if (!is_null($categoryType) && !is_string($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \rdyescapia\StructType\ReviewScoreType
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\ReviewScoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
