<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationUpdate StructType
 * @subpackage Structs
 */
class ReservationUpdate extends AbstractStructBase
{
    /**
     * The ReservationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationID;
    /**
     * The UnitID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitID;
    /**
     * The AgencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The BookingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingNumber;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The ReservationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationType;
    /**
     * The UnitRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate
     */
    public $UnitRates;
    /**
     * Constructor method for ReservationUpdate
     * @uses ReservationUpdate::setReservationID()
     * @uses ReservationUpdate::setUnitID()
     * @uses ReservationUpdate::setAgencyID()
     * @uses ReservationUpdate::setStartDate()
     * @uses ReservationUpdate::setEndDate()
     * @uses ReservationUpdate::setBookingNumber()
     * @uses ReservationUpdate::setCreationDate()
     * @uses ReservationUpdate::setReservationType()
     * @uses ReservationUpdate::setUnitRates()
     * @param string $reservationID
     * @param string $unitID
     * @param string $agencyID
     * @param string $startDate
     * @param string $endDate
     * @param string $bookingNumber
     * @param string $creationDate
     * @param string $reservationType
     * @param \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate $unitRates
     */
    public function __construct($reservationID = null, $unitID = null, $agencyID = null, $startDate = null, $endDate = null, $bookingNumber = null, $creationDate = null, $reservationType = null, \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate $unitRates = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setUnitID($unitID)
            ->setAgencyID($agencyID)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setBookingNumber($bookingNumber)
            ->setCreationDate($creationDate)
            ->setReservationType($reservationType)
            ->setUnitRates($unitRates);
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get UnitID value
     * @return string|null
     */
    public function getUnitID()
    {
        return $this->UnitID;
    }
    /**
     * Set UnitID value
     * @param string $unitID
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setUnitID($unitID = null)
    {
        // validation for constraint: string
        if (!is_null($unitID) && !is_string($unitID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitID)), __LINE__);
        }
        $this->UnitID = $unitID;
        return $this;
    }
    /**
     * Get AgencyID value
     * @return string|null
     */
    public function getAgencyID()
    {
        return $this->AgencyID;
    }
    /**
     * Set AgencyID value
     * @param string $agencyID
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setAgencyID($agencyID = null)
    {
        // validation for constraint: string
        if (!is_null($agencyID) && !is_string($agencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyID)), __LINE__);
        }
        $this->AgencyID = $agencyID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get BookingNumber value
     * @return string|null
     */
    public function getBookingNumber()
    {
        return $this->BookingNumber;
    }
    /**
     * Set BookingNumber value
     * @param string $bookingNumber
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setBookingNumber($bookingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bookingNumber) && !is_string($bookingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingNumber)), __LINE__);
        }
        $this->BookingNumber = $bookingNumber;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @param string $reservationType
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationType)), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
    /**
     * Get UnitRates value
     * @return \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate|null
     */
    public function getUnitRates()
    {
        return $this->UnitRates;
    }
    /**
     * Set UnitRates value
     * @param \rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate $unitRates
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public function setUnitRates(\rdyescapia\ArrayType\ArrayOfReservationUpdateUnitRate $unitRates = null)
    {
        $this->UnitRates = $unitRates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\ReservationUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
