<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagers StructType
 * @subpackage Structs
 */
class PropertyManagers extends AbstractStructBase
{
    /**
     * The PropertyManager
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PropertyManagerType[]
     */
    public $PropertyManager;
    /**
     * Constructor method for PropertyManagers
     * @uses PropertyManagers::setPropertyManager()
     * @param \rdyescapia\StructType\PropertyManagerType[] $propertyManager
     */
    public function __construct(array $propertyManager = array())
    {
        $this
            ->setPropertyManager($propertyManager);
    }
    /**
     * Get PropertyManager value
     * @return \rdyescapia\StructType\PropertyManagerType[]|null
     */
    public function getPropertyManager()
    {
        return $this->PropertyManager;
    }
    /**
     * Set PropertyManager value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PropertyManagerType[] $propertyManager
     * @return \rdyescapia\StructType\PropertyManagers
     */
    public function setPropertyManager(array $propertyManager = array())
    {
        foreach ($propertyManager as $propertyManagersPropertyManagerItem) {
            // validation for constraint: itemType
            if (!$propertyManagersPropertyManagerItem instanceof \rdyescapia\StructType\PropertyManagerType) {
                throw new \InvalidArgumentException(sprintf('The PropertyManager property can only contain items of \rdyescapia\StructType\PropertyManagerType, "%s" given', is_object($propertyManagersPropertyManagerItem) ? get_class($propertyManagersPropertyManagerItem) : gettype($propertyManagersPropertyManagerItem)), __LINE__);
            }
        }
        $this->PropertyManager = $propertyManager;
        return $this;
    }
    /**
     * Add item to PropertyManager value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PropertyManagerType $item
     * @return \rdyescapia\StructType\PropertyManagers
     */
    public function addToPropertyManager(\rdyescapia\StructType\PropertyManagerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PropertyManagerType) {
            throw new \InvalidArgumentException(sprintf('The PropertyManager property can only contain items of \rdyescapia\StructType\PropertyManagerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyManager[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PropertyManagers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
