<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagerReviewType StructType
 * @subpackage Structs
 */
class PropertyManagerReviewType extends AbstractStructBase
{
    /**
     * The AverageReviewScore
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ReviewScoreType[]
     */
    public $AverageReviewScore;
    /**
     * The ReviewCount
     * @var int
     */
    public $ReviewCount;
    /**
     * Constructor method for PropertyManagerReviewType
     * @uses PropertyManagerReviewType::setAverageReviewScore()
     * @uses PropertyManagerReviewType::setReviewCount()
     * @param \rdyescapia\StructType\ReviewScoreType[] $averageReviewScore
     * @param int $reviewCount
     */
    public function __construct(array $averageReviewScore = array(), $reviewCount = null)
    {
        $this
            ->setAverageReviewScore($averageReviewScore)
            ->setReviewCount($reviewCount);
    }
    /**
     * Get AverageReviewScore value
     * @return \rdyescapia\StructType\ReviewScoreType[]|null
     */
    public function getAverageReviewScore()
    {
        return $this->AverageReviewScore;
    }
    /**
     * Set AverageReviewScore value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ReviewScoreType[] $averageReviewScore
     * @return \rdyescapia\StructType\PropertyManagerReviewType
     */
    public function setAverageReviewScore(array $averageReviewScore = array())
    {
        foreach ($averageReviewScore as $propertyManagerReviewTypeAverageReviewScoreItem) {
            // validation for constraint: itemType
            if (!$propertyManagerReviewTypeAverageReviewScoreItem instanceof \rdyescapia\StructType\ReviewScoreType) {
                throw new \InvalidArgumentException(sprintf('The AverageReviewScore property can only contain items of \rdyescapia\StructType\ReviewScoreType, "%s" given', is_object($propertyManagerReviewTypeAverageReviewScoreItem) ? get_class($propertyManagerReviewTypeAverageReviewScoreItem) : gettype($propertyManagerReviewTypeAverageReviewScoreItem)), __LINE__);
            }
        }
        $this->AverageReviewScore = $averageReviewScore;
        return $this;
    }
    /**
     * Add item to AverageReviewScore value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ReviewScoreType $item
     * @return \rdyescapia\StructType\PropertyManagerReviewType
     */
    public function addToAverageReviewScore(\rdyescapia\StructType\ReviewScoreType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ReviewScoreType) {
            throw new \InvalidArgumentException(sprintf('The AverageReviewScore property can only contain items of \rdyescapia\StructType\ReviewScoreType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AverageReviewScore[] = $item;
        return $this;
    }
    /**
     * Get ReviewCount value
     * @return int|null
     */
    public function getReviewCount()
    {
        return $this->ReviewCount;
    }
    /**
     * Set ReviewCount value
     * @param int $reviewCount
     * @return \rdyescapia\StructType\PropertyManagerReviewType
     */
    public function setReviewCount($reviewCount = null)
    {
        // validation for constraint: int
        if (!is_null($reviewCount) && !is_numeric($reviewCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reviewCount)), __LINE__);
        }
        $this->ReviewCount = $reviewCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PropertyManagerReviewType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
