<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrefCollection StructType
 * @subpackage Structs
 */
class PrefCollection extends AbstractStructBase
{
    /**
     * The CommonPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CommonPrefType[]
     */
    public $CommonPref;
    /**
     * The VehicleRentalPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\VehicleProfileRentalPrefType[]
     */
    public $VehicleRentalPref;
    /**
     * The AirlinePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AirlinePrefType[]
     */
    public $AirlinePref;
    /**
     * The HotelPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\HotelPrefType[]
     */
    public $HotelPref;
    /**
     * The OtherSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\OtherSrvcPrefType[]
     */
    public $OtherSrvcPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for PrefCollection
     * @uses PrefCollection::setCommonPref()
     * @uses PrefCollection::setVehicleRentalPref()
     * @uses PrefCollection::setAirlinePref()
     * @uses PrefCollection::setHotelPref()
     * @uses PrefCollection::setOtherSrvcPref()
     * @uses PrefCollection::setTPA_Extensions()
     * @uses PrefCollection::setShareSynchInd()
     * @uses PrefCollection::setShareMarketInd()
     * @uses PrefCollection::setTravelPurpose()
     * @param \rdyescapia\StructType\CommonPrefType[] $commonPref
     * @param \rdyescapia\StructType\VehicleProfileRentalPrefType[] $vehicleRentalPref
     * @param \rdyescapia\StructType\AirlinePrefType[] $airlinePref
     * @param \rdyescapia\StructType\HotelPrefType[] $hotelPref
     * @param \rdyescapia\StructType\OtherSrvcPrefType[] $otherSrvcPref
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $travelPurpose
     */
    public function __construct(array $commonPref = array(), array $vehicleRentalPref = array(), array $airlinePref = array(), array $hotelPref = array(), array $otherSrvcPref = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $travelPurpose = null)
    {
        $this
            ->setCommonPref($commonPref)
            ->setVehicleRentalPref($vehicleRentalPref)
            ->setAirlinePref($airlinePref)
            ->setHotelPref($hotelPref)
            ->setOtherSrvcPref($otherSrvcPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get CommonPref value
     * @return \rdyescapia\StructType\CommonPrefType[]|null
     */
    public function getCommonPref()
    {
        return $this->CommonPref;
    }
    /**
     * Set CommonPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CommonPrefType[] $commonPref
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setCommonPref(array $commonPref = array())
    {
        foreach ($commonPref as $prefCollectionCommonPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionCommonPrefItem instanceof \rdyescapia\StructType\CommonPrefType) {
                throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of \rdyescapia\StructType\CommonPrefType, "%s" given', is_object($prefCollectionCommonPrefItem) ? get_class($prefCollectionCommonPrefItem) : gettype($prefCollectionCommonPrefItem)), __LINE__);
            }
        }
        $this->CommonPref = $commonPref;
        return $this;
    }
    /**
     * Add item to CommonPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CommonPrefType $item
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function addToCommonPref(\rdyescapia\StructType\CommonPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CommonPrefType) {
            throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of \rdyescapia\StructType\CommonPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommonPref[] = $item;
        return $this;
    }
    /**
     * Get VehicleRentalPref value
     * @return \rdyescapia\StructType\VehicleProfileRentalPrefType[]|null
     */
    public function getVehicleRentalPref()
    {
        return $this->VehicleRentalPref;
    }
    /**
     * Set VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\VehicleProfileRentalPrefType[] $vehicleRentalPref
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setVehicleRentalPref(array $vehicleRentalPref = array())
    {
        foreach ($vehicleRentalPref as $prefCollectionVehicleRentalPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionVehicleRentalPrefItem instanceof \rdyescapia\StructType\VehicleProfileRentalPrefType) {
                throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of \rdyescapia\StructType\VehicleProfileRentalPrefType, "%s" given', is_object($prefCollectionVehicleRentalPrefItem) ? get_class($prefCollectionVehicleRentalPrefItem) : gettype($prefCollectionVehicleRentalPrefItem)), __LINE__);
            }
        }
        $this->VehicleRentalPref = $vehicleRentalPref;
        return $this;
    }
    /**
     * Add item to VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\VehicleProfileRentalPrefType $item
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function addToVehicleRentalPref(\rdyescapia\StructType\VehicleProfileRentalPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\VehicleProfileRentalPrefType) {
            throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of \rdyescapia\StructType\VehicleProfileRentalPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleRentalPref[] = $item;
        return $this;
    }
    /**
     * Get AirlinePref value
     * @return \rdyescapia\StructType\AirlinePrefType[]|null
     */
    public function getAirlinePref()
    {
        return $this->AirlinePref;
    }
    /**
     * Set AirlinePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirlinePrefType[] $airlinePref
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setAirlinePref(array $airlinePref = array())
    {
        foreach ($airlinePref as $prefCollectionAirlinePrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionAirlinePrefItem instanceof \rdyescapia\StructType\AirlinePrefType) {
                throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of \rdyescapia\StructType\AirlinePrefType, "%s" given', is_object($prefCollectionAirlinePrefItem) ? get_class($prefCollectionAirlinePrefItem) : gettype($prefCollectionAirlinePrefItem)), __LINE__);
            }
        }
        $this->AirlinePref = $airlinePref;
        return $this;
    }
    /**
     * Add item to AirlinePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirlinePrefType $item
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function addToAirlinePref(\rdyescapia\StructType\AirlinePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AirlinePrefType) {
            throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of \rdyescapia\StructType\AirlinePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirlinePref[] = $item;
        return $this;
    }
    /**
     * Get HotelPref value
     * @return \rdyescapia\StructType\HotelPrefType[]|null
     */
    public function getHotelPref()
    {
        return $this->HotelPref;
    }
    /**
     * Set HotelPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\HotelPrefType[] $hotelPref
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setHotelPref(array $hotelPref = array())
    {
        foreach ($hotelPref as $prefCollectionHotelPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionHotelPrefItem instanceof \rdyescapia\StructType\HotelPrefType) {
                throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of \rdyescapia\StructType\HotelPrefType, "%s" given', is_object($prefCollectionHotelPrefItem) ? get_class($prefCollectionHotelPrefItem) : gettype($prefCollectionHotelPrefItem)), __LINE__);
            }
        }
        $this->HotelPref = $hotelPref;
        return $this;
    }
    /**
     * Add item to HotelPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\HotelPrefType $item
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function addToHotelPref(\rdyescapia\StructType\HotelPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\HotelPrefType) {
            throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of \rdyescapia\StructType\HotelPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelPref[] = $item;
        return $this;
    }
    /**
     * Get OtherSrvcPref value
     * @return \rdyescapia\StructType\OtherSrvcPrefType[]|null
     */
    public function getOtherSrvcPref()
    {
        return $this->OtherSrvcPref;
    }
    /**
     * Set OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\OtherSrvcPrefType[] $otherSrvcPref
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setOtherSrvcPref(array $otherSrvcPref = array())
    {
        foreach ($otherSrvcPref as $prefCollectionOtherSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionOtherSrvcPrefItem instanceof \rdyescapia\StructType\OtherSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of \rdyescapia\StructType\OtherSrvcPrefType, "%s" given', is_object($prefCollectionOtherSrvcPrefItem) ? get_class($prefCollectionOtherSrvcPrefItem) : gettype($prefCollectionOtherSrvcPrefItem)), __LINE__);
            }
        }
        $this->OtherSrvcPref = $otherSrvcPref;
        return $this;
    }
    /**
     * Add item to OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\OtherSrvcPrefType $item
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function addToOtherSrvcPref(\rdyescapia\StructType\OtherSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\OtherSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of \rdyescapia\StructType\OtherSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OtherSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \rdyescapia\StructType\PrefCollection
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PrefCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
