<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherSrvcPrefType StructType
 * @subpackage Structs
 */
class OtherSrvcPrefType extends AbstractStructBase
{
    /**
     * The OtherSrvcName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherSrvcName;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for OtherSrvcPrefType
     * @uses OtherSrvcPrefType::setOtherSrvcName()
     * @uses OtherSrvcPrefType::setVendorPref()
     * @uses OtherSrvcPrefType::setLoyaltyPref()
     * @uses OtherSrvcPrefType::setPaymentFormPref()
     * @uses OtherSrvcPrefType::setSpecRequestPref()
     * @uses OtherSrvcPrefType::setTPA_Extensions()
     * @uses OtherSrvcPrefType::setPreferLevel()
     * @uses OtherSrvcPrefType::setShareSynchInd()
     * @uses OtherSrvcPrefType::setShareMarketInd()
     * @uses OtherSrvcPrefType::setTravelPurpose()
     * @param string $otherSrvcName
     * @param \rdyescapia\StructType\CompanyNamePrefType[] $vendorPref
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $travelPurpose
     */
    public function __construct($otherSrvcName = null, array $vendorPref = array(), array $loyaltyPref = array(), array $paymentFormPref = array(), array $specRequestPref = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $travelPurpose = null)
    {
        $this
            ->setOtherSrvcName($otherSrvcName)
            ->setVendorPref($vendorPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setSpecRequestPref($specRequestPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get OtherSrvcName value
     * @return string|null
     */
    public function getOtherSrvcName()
    {
        return $this->OtherSrvcName;
    }
    /**
     * Set OtherSrvcName value
     * @param string $otherSrvcName
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setOtherSrvcName($otherSrvcName = null)
    {
        // validation for constraint: string
        if (!is_null($otherSrvcName) && !is_string($otherSrvcName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherSrvcName)), __LINE__);
        }
        $this->OtherSrvcName = $otherSrvcName;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \rdyescapia\StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNamePrefType[] $vendorPref
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $otherSrvcPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypeVendorPrefItem instanceof \rdyescapia\StructType\CompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapia\StructType\CompanyNamePrefType, "%s" given', is_object($otherSrvcPrefTypeVendorPrefItem) ? get_class($otherSrvcPrefTypeVendorPrefItem) : gettype($otherSrvcPrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNamePrefType $item
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function addToVendorPref(\rdyescapia\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapia\StructType\CompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return \rdyescapia\StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $otherSrvcPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypeLoyaltyPrefItem instanceof \rdyescapia\StructType\LoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapia\StructType\LoyaltyPrefType, "%s" given', is_object($otherSrvcPrefTypeLoyaltyPrefItem) ? get_class($otherSrvcPrefTypeLoyaltyPrefItem) : gettype($otherSrvcPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType $item
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function addToLoyaltyPref(\rdyescapia\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapia\StructType\LoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \rdyescapia\StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $otherSrvcPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypePaymentFormPrefItem instanceof \rdyescapia\StructType\PaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapia\StructType\PaymentFormPrefType, "%s" given', is_object($otherSrvcPrefTypePaymentFormPrefItem) ? get_class($otherSrvcPrefTypePaymentFormPrefItem) : gettype($otherSrvcPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType $item
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function addToPaymentFormPref(\rdyescapia\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapia\StructType\PaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \rdyescapia\StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $otherSrvcPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypeSpecRequestPrefItem instanceof \rdyescapia\StructType\SpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \rdyescapia\StructType\SpecRequestPrefType, "%s" given', is_object($otherSrvcPrefTypeSpecRequestPrefItem) ? get_class($otherSrvcPrefTypeSpecRequestPrefItem) : gettype($otherSrvcPrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType $item
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function addToSpecRequestPref(\rdyescapia\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \rdyescapia\StructType\SpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\OtherSrvcPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
