<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The VendorCode
     * @var string[]
     */
    public $VendorCode;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setMembershipID()
     * @uses CustLoyalty::setTravelSector()
     * @uses CustLoyalty::setRPH()
     * @uses CustLoyalty::setVendorCode()
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $rPH
     * @param string[] $vendorCode
     */
    public function __construct($programID = null, $membershipID = null, $travelSector = null, $rPH = null, array $vendorCode = array())
    {
        $this
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setRPH($rPH)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $vendorCode
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function setVendorCode(array $vendorCode = array())
    {
        foreach ($vendorCode as $custLoyaltyVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($custLoyaltyVendorCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($custLoyaltyVendorCodeItem) ? get_class($custLoyaltyVendorCodeItem) : gettype($custLoyaltyVendorCodeItem)), __LINE__);
            }
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Add item to VendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public function addToVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
