<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonNameType
     */
    public $Name;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmailType[]
     */
    public $Email;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TelephoneInfoType[]
     */
    public $Telephone;
    /**
     * The PreferredContactMethod
     * @var string
     */
    public $PreferredContactMethod;
    /**
     * The IPAddress
     * @var string
     */
    public $IPAddress;
    /**
     * Constructor method for Contact
     * @uses Contact::setName()
     * @uses Contact::setEmail()
     * @uses Contact::setTelephone()
     * @uses Contact::setPreferredContactMethod()
     * @uses Contact::setIPAddress()
     * @param \rdyescapia\StructType\PersonNameType $name
     * @param \rdyescapia\StructType\EmailType[] $email
     * @param \rdyescapia\StructType\TelephoneInfoType[] $telephone
     * @param string $preferredContactMethod
     * @param string $iPAddress
     */
    public function __construct(\rdyescapia\StructType\PersonNameType $name = null, array $email = array(), array $telephone = array(), $preferredContactMethod = null, $iPAddress = null)
    {
        $this
            ->setName($name)
            ->setEmail($email)
            ->setTelephone($telephone)
            ->setPreferredContactMethod($preferredContactMethod)
            ->setIPAddress($iPAddress);
    }
    /**
     * Get Name value
     * @return \rdyescapia\StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \rdyescapia\StructType\PersonNameType $name
     * @return \rdyescapia\StructType\Contact
     */
    public function setName(\rdyescapia\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapia\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType[] $email
     * @return \rdyescapia\StructType\Contact
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $contactEmailItem) {
            // validation for constraint: itemType
            if (!$contactEmailItem instanceof \rdyescapia\StructType\EmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \rdyescapia\StructType\EmailType, "%s" given', is_object($contactEmailItem) ? get_class($contactEmailItem) : gettype($contactEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType $item
     * @return \rdyescapia\StructType\Contact
     */
    public function addToEmail(\rdyescapia\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \rdyescapia\StructType\EmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \rdyescapia\StructType\TelephoneInfoType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TelephoneInfoType[] $telephone
     * @return \rdyescapia\StructType\Contact
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $contactTelephoneItem) {
            // validation for constraint: itemType
            if (!$contactTelephoneItem instanceof \rdyescapia\StructType\TelephoneInfoType) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \rdyescapia\StructType\TelephoneInfoType, "%s" given', is_object($contactTelephoneItem) ? get_class($contactTelephoneItem) : gettype($contactTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TelephoneInfoType $item
     * @return \rdyescapia\StructType\Contact
     */
    public function addToTelephone(\rdyescapia\StructType\TelephoneInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TelephoneInfoType) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \rdyescapia\StructType\TelephoneInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get PreferredContactMethod value
     * @return string|null
     */
    public function getPreferredContactMethod()
    {
        return $this->PreferredContactMethod;
    }
    /**
     * Set PreferredContactMethod value
     * @uses \rdyescapia\EnumType\PreferredContactMethodType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferredContactMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredContactMethod
     * @return \rdyescapia\StructType\Contact
     */
    public function setPreferredContactMethod($preferredContactMethod = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferredContactMethodType::valueIsValid($preferredContactMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferredContactMethod, implode(', ', \rdyescapia\EnumType\PreferredContactMethodType::getValidValues())), __LINE__);
        }
        $this->PreferredContactMethod = $preferredContactMethod;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \rdyescapia\StructType\Contact
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
