<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyNamePrefType StructType
 * @subpackage Structs
 */
class CompanyNamePrefType extends CompanyNameType
{
    /**
     * The _
     * @var \rdyescapia\StructType\CompanyNameType
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for CompanyNamePrefType
     * @uses CompanyNamePrefType::set_()
     * @uses CompanyNamePrefType::setPreferLevel()
     * @param \rdyescapia\StructType\CompanyNameType $_
     * @param string $preferLevel
     */
    public function __construct(\rdyescapia\StructType\CompanyNameType $_ = null, $preferLevel = 'Preferred')
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return \rdyescapia\StructType\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \rdyescapia\StructType\CompanyNameType $_
     * @return \rdyescapia\StructType\CompanyNamePrefType
     */
    public function set_(\rdyescapia\StructType\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\CompanyNamePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CompanyNamePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
