<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInquiryRequestType ArrayType
 * @subpackage Arrays
 */
class ArrayOfInquiryRequestType extends AbstractStructArrayBase
{
    /**
     * The InquiryRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\InquiryRequestType[]
     */
    public $InquiryRequest;
    /**
     * Constructor method for ArrayOfInquiryRequestType
     * @uses ArrayOfInquiryRequestType::setInquiryRequest()
     * @param \rdyescapia\StructType\InquiryRequestType[] $inquiryRequest
     */
    public function __construct(array $inquiryRequest = array())
    {
        $this
            ->setInquiryRequest($inquiryRequest);
    }
    /**
     * Get InquiryRequest value
     * @return \rdyescapia\StructType\InquiryRequestType[]|null
     */
    public function getInquiryRequest()
    {
        return $this->InquiryRequest;
    }
    /**
     * Set InquiryRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InquiryRequestType[] $inquiryRequest
     * @return \rdyescapia\ArrayType\ArrayOfInquiryRequestType
     */
    public function setInquiryRequest(array $inquiryRequest = array())
    {
        foreach ($inquiryRequest as $arrayOfInquiryRequestTypeInquiryRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfInquiryRequestTypeInquiryRequestItem instanceof \rdyescapia\StructType\InquiryRequestType) {
                throw new \InvalidArgumentException(sprintf('The InquiryRequest property can only contain items of \rdyescapia\StructType\InquiryRequestType, "%s" given', is_object($arrayOfInquiryRequestTypeInquiryRequestItem) ? get_class($arrayOfInquiryRequestTypeInquiryRequestItem) : gettype($arrayOfInquiryRequestTypeInquiryRequestItem)), __LINE__);
            }
        }
        $this->InquiryRequest = $inquiryRequest;
        return $this;
    }
    /**
     * Add item to InquiryRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InquiryRequestType $item
     * @return \rdyescapia\ArrayType\ArrayOfInquiryRequestType
     */
    public function addToInquiryRequest(\rdyescapia\StructType\InquiryRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\InquiryRequestType) {
            throw new \InvalidArgumentException(sprintf('The InquiryRequest property can only contain items of \rdyescapia\StructType\InquiryRequestType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InquiryRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\InquiryRequestType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InquiryRequest
     */
    public function getAttributeName()
    {
        return 'InquiryRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\ArrayType\ArrayOfInquiryRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
