<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitResResponseType StructType
 * @subpackage Structs
 */
class UnitResResponseType extends EVRN_BaseRSType
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfSourceType
     */
    public $POS;
    /**
     * The UnitReservations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitReservationsType
     */
    public $UnitReservations;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\WarningsType
     */
    public $Warnings;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for UnitResResponseType
     * @uses UnitResResponseType::setPOS()
     * @uses UnitResResponseType::setUnitReservations()
     * @uses UnitResResponseType::setErrors()
     * @uses UnitResResponseType::setSuccess()
     * @uses UnitResResponseType::setWarnings()
     * @uses UnitResResponseType::setResResponseType()
     * @param \rdyescapia\ArrayType\ArrayOfSourceType $pOS
     * @param \rdyescapia\StructType\UnitReservationsType $unitReservations
     * @param \rdyescapia\StructType\ErrorsType $errors
     * @param \rdyescapia\StructType\SuccessType $success
     * @param \rdyescapia\StructType\WarningsType $warnings
     * @param string $resResponseType
     */
    public function __construct(\rdyescapia\ArrayType\ArrayOfSourceType $pOS = null, \rdyescapia\StructType\UnitReservationsType $unitReservations = null, \rdyescapia\StructType\ErrorsType $errors = null, \rdyescapia\StructType\SuccessType $success = null, \rdyescapia\StructType\WarningsType $warnings = null, $resResponseType = null)
    {
        $this
            ->setPOS($pOS)
            ->setUnitReservations($unitReservations)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get POS value
     * @return \rdyescapia\ArrayType\ArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \rdyescapia\ArrayType\ArrayOfSourceType $pOS
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setPOS(\rdyescapia\ArrayType\ArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UnitReservations value
     * @return \rdyescapia\StructType\UnitReservationsType|null
     */
    public function getUnitReservations()
    {
        return $this->UnitReservations;
    }
    /**
     * Set UnitReservations value
     * @param \rdyescapia\StructType\UnitReservationsType $unitReservations
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setUnitReservations(\rdyescapia\StructType\UnitReservationsType $unitReservations = null)
    {
        $this->UnitReservations = $unitReservations;
        return $this;
    }
    /**
     * Get Errors value
     * @return \rdyescapia\StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \rdyescapia\StructType\ErrorsType $errors
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setErrors(\rdyescapia\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Success value
     * @return \rdyescapia\StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \rdyescapia\StructType\SuccessType $success
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setSuccess(\rdyescapia\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \rdyescapia\StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \rdyescapia\StructType\WarningsType $warnings
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setWarnings(\rdyescapia\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \rdyescapia\EnumType\TransactionStatusType::valueIsValid()
     * @uses \rdyescapia\EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\TransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resResponseType, implode(', ', \rdyescapia\EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitResResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
