<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveContentType StructType
 * @subpackage Structs
 */
class UnitDescriptiveContentType extends AbstractStructBase
{
    /**
     * The UnitInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitInfoType
     */
    public $UnitInfo;
    /**
     * The Policies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy
     */
    public $Policies;
    /**
     * The UnitReviews
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitReviewsType
     */
    public $UnitReviews;
    /**
     * The Promotions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PromotionsType
     */
    public $Promotions;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The PropertyURL
     * @var string
     */
    public $PropertyURL;
    /**
     * Constructor method for UnitDescriptiveContentType
     * @uses UnitDescriptiveContentType::setUnitInfo()
     * @uses UnitDescriptiveContentType::setPolicies()
     * @uses UnitDescriptiveContentType::setUnitReviews()
     * @uses UnitDescriptiveContentType::setPromotions()
     * @uses UnitDescriptiveContentType::setPropertyManagerCode()
     * @uses UnitDescriptiveContentType::setUnitCode()
     * @uses UnitDescriptiveContentType::setUnitName()
     * @uses UnitDescriptiveContentType::setInfoSource()
     * @uses UnitDescriptiveContentType::setInternalUnitCode()
     * @uses UnitDescriptiveContentType::setUnitHeadline()
     * @uses UnitDescriptiveContentType::setPropertyURL()
     * @param \rdyescapia\StructType\UnitInfoType $unitInfo
     * @param \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies
     * @param \rdyescapia\StructType\UnitReviewsType $unitReviews
     * @param \rdyescapia\StructType\PromotionsType $promotions
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $propertyURL
     */
    public function __construct(\rdyescapia\StructType\UnitInfoType $unitInfo = null, \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies = null, \rdyescapia\StructType\UnitReviewsType $unitReviews = null, \rdyescapia\StructType\PromotionsType $promotions = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $propertyURL = null)
    {
        $this
            ->setUnitInfo($unitInfo)
            ->setPolicies($policies)
            ->setUnitReviews($unitReviews)
            ->setPromotions($promotions)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setPropertyURL($propertyURL);
    }
    /**
     * Get UnitInfo value
     * @return \rdyescapia\StructType\UnitInfoType|null
     */
    public function getUnitInfo()
    {
        return $this->UnitInfo;
    }
    /**
     * Set UnitInfo value
     * @param \rdyescapia\StructType\UnitInfoType $unitInfo
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setUnitInfo(\rdyescapia\StructType\UnitInfoType $unitInfo = null)
    {
        $this->UnitInfo = $unitInfo;
        return $this;
    }
    /**
     * Get Policies value
     * @return \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy|null
     */
    public function getPolicies()
    {
        return $this->Policies;
    }
    /**
     * Set Policies value
     * @param \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setPolicies(\rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy $policies = null)
    {
        $this->Policies = $policies;
        return $this;
    }
    /**
     * Get UnitReviews value
     * @return \rdyescapia\StructType\UnitReviewsType|null
     */
    public function getUnitReviews()
    {
        return $this->UnitReviews;
    }
    /**
     * Set UnitReviews value
     * @param \rdyescapia\StructType\UnitReviewsType $unitReviews
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setUnitReviews(\rdyescapia\StructType\UnitReviewsType $unitReviews = null)
    {
        $this->UnitReviews = $unitReviews;
        return $this;
    }
    /**
     * Get Promotions value
     * @return \rdyescapia\StructType\PromotionsType|null
     */
    public function getPromotions()
    {
        return $this->Promotions;
    }
    /**
     * Set Promotions value
     * @param \rdyescapia\StructType\PromotionsType $promotions
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setPromotions(\rdyescapia\StructType\PromotionsType $promotions = null)
    {
        $this->Promotions = $promotions;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get PropertyURL value
     * @return string|null
     */
    public function getPropertyURL()
    {
        return $this->PropertyURL;
    }
    /**
     * Set PropertyURL value
     * @param string $propertyURL
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public function setPropertyURL($propertyURL = null)
    {
        // validation for constraint: string
        if (!is_null($propertyURL) && !is_string($propertyURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyURL)), __LINE__);
        }
        $this->PropertyURL = $propertyURL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\UnitDescriptiveContentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
