<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchAreaType StructType
 * @subpackage Structs
 */
class SearchAreaType extends AreaType
{
    /**
     * The UnitCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitCount[]
     */
    public $UnitCount;
    /**
     * The ZipList
     * @var string[]
     */
    public $ZipList;
    /**
     * The MinDiscount
     * @var float
     */
    public $MinDiscount;
    /**
     * The MaxDiscount
     * @var float
     */
    public $MaxDiscount;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for SearchAreaType
     * @uses SearchAreaType::setUnitCount()
     * @uses SearchAreaType::setZipList()
     * @uses SearchAreaType::setMinDiscount()
     * @uses SearchAreaType::setMaxDiscount()
     * @uses SearchAreaType::setStartDate()
     * @uses SearchAreaType::setEndDate()
     * @param \rdyescapia\StructType\UnitCount[] $unitCount
     * @param string[] $zipList
     * @param float $minDiscount
     * @param float $maxDiscount
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(array $unitCount = array(), array $zipList = array(), $minDiscount = null, $maxDiscount = null, $startDate = null, $endDate = null)
    {
        $this
            ->setUnitCount($unitCount)
            ->setZipList($zipList)
            ->setMinDiscount($minDiscount)
            ->setMaxDiscount($maxDiscount)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get UnitCount value
     * @return \rdyescapia\StructType\UnitCount[]|null
     */
    public function getUnitCount()
    {
        return $this->UnitCount;
    }
    /**
     * Set UnitCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitCount[] $unitCount
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function setUnitCount(array $unitCount = array())
    {
        foreach ($unitCount as $searchAreaTypeUnitCountItem) {
            // validation for constraint: itemType
            if (!$searchAreaTypeUnitCountItem instanceof \rdyescapia\StructType\UnitCount) {
                throw new \InvalidArgumentException(sprintf('The UnitCount property can only contain items of \rdyescapia\StructType\UnitCount, "%s" given', is_object($searchAreaTypeUnitCountItem) ? get_class($searchAreaTypeUnitCountItem) : gettype($searchAreaTypeUnitCountItem)), __LINE__);
            }
        }
        $this->UnitCount = $unitCount;
        return $this;
    }
    /**
     * Add item to UnitCount value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitCount $item
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function addToUnitCount(\rdyescapia\StructType\UnitCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitCount) {
            throw new \InvalidArgumentException(sprintf('The UnitCount property can only contain items of \rdyescapia\StructType\UnitCount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitCount[] = $item;
        return $this;
    }
    /**
     * Get ZipList value
     * @return string[]|null
     */
    public function getZipList()
    {
        return $this->ZipList;
    }
    /**
     * Set ZipList value
     * @throws \InvalidArgumentException
     * @param string[] $zipList
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function setZipList(array $zipList = array())
    {
        foreach ($zipList as $searchAreaTypeZipListItem) {
            // validation for constraint: itemType
            if (!is_string($searchAreaTypeZipListItem)) {
                throw new \InvalidArgumentException(sprintf('The ZipList property can only contain items of string, "%s" given', is_object($searchAreaTypeZipListItem) ? get_class($searchAreaTypeZipListItem) : gettype($searchAreaTypeZipListItem)), __LINE__);
            }
        }
        $this->ZipList = $zipList;
        return $this;
    }
    /**
     * Add item to ZipList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function addToZipList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ZipList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ZipList[] = $item;
        return $this;
    }
    /**
     * Get MinDiscount value
     * @return float|null
     */
    public function getMinDiscount()
    {
        return $this->MinDiscount;
    }
    /**
     * Set MinDiscount value
     * @param float $minDiscount
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function setMinDiscount($minDiscount = null)
    {
        $this->MinDiscount = $minDiscount;
        return $this;
    }
    /**
     * Get MaxDiscount value
     * @return float|null
     */
    public function getMaxDiscount()
    {
        return $this->MaxDiscount;
    }
    /**
     * Set MaxDiscount value
     * @param float $maxDiscount
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function setMaxDiscount($maxDiscount = null)
    {
        $this->MaxDiscount = $maxDiscount;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\SearchAreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
