<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreferencesType StructType
 * @subpackage Structs
 */
class PreferencesType extends AbstractStructBase
{
    /**
     * The PrefCollection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PrefCollection[]
     */
    public $PrefCollection;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for PreferencesType
     * @uses PreferencesType::setPrefCollection()
     * @uses PreferencesType::setShareSynchInd()
     * @uses PreferencesType::setShareMarketInd()
     * @param \rdyescapia\StructType\PrefCollection[] $prefCollection
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $prefCollection = array(), $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setPrefCollection($prefCollection)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get PrefCollection value
     * @return \rdyescapia\StructType\PrefCollection[]|null
     */
    public function getPrefCollection()
    {
        return $this->PrefCollection;
    }
    /**
     * Set PrefCollection value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PrefCollection[] $prefCollection
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function setPrefCollection(array $prefCollection = array())
    {
        foreach ($prefCollection as $preferencesTypePrefCollectionItem) {
            // validation for constraint: itemType
            if (!$preferencesTypePrefCollectionItem instanceof \rdyescapia\StructType\PrefCollection) {
                throw new \InvalidArgumentException(sprintf('The PrefCollection property can only contain items of \rdyescapia\StructType\PrefCollection, "%s" given', is_object($preferencesTypePrefCollectionItem) ? get_class($preferencesTypePrefCollectionItem) : gettype($preferencesTypePrefCollectionItem)), __LINE__);
            }
        }
        $this->PrefCollection = $prefCollection;
        return $this;
    }
    /**
     * Add item to PrefCollection value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PrefCollection $item
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function addToPrefCollection(\rdyescapia\StructType\PrefCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PrefCollection) {
            throw new \InvalidArgumentException(sprintf('The PrefCollection property can only contain items of \rdyescapia\StructType\PrefCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PrefCollection[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\PreferencesType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PreferencesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
