<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType StructType
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NamePrefix;
    /**
     * The GivenName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SurnamePrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurnamePrefix;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NameSuffix;
    /**
     * The NameTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NameTitle;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The NameType
     * @var string
     */
    public $NameType;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setNamePrefix()
     * @uses PersonNameType::setGivenName()
     * @uses PersonNameType::setMiddleName()
     * @uses PersonNameType::setSurnamePrefix()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setNameSuffix()
     * @uses PersonNameType::setNameTitle()
     * @uses PersonNameType::setShareSynchInd()
     * @uses PersonNameType::setShareMarketInd()
     * @uses PersonNameType::setNameType()
     * @param string[] $namePrefix
     * @param string[] $givenName
     * @param string[] $middleName
     * @param string $surnamePrefix
     * @param string $surname
     * @param string[] $nameSuffix
     * @param string[] $nameTitle
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $nameType
     */
    public function __construct(array $namePrefix = array(), array $givenName = array(), array $middleName = array(), $surnamePrefix = null, $surname = null, array $nameSuffix = array(), array $nameTitle = array(), $shareSynchInd = null, $shareMarketInd = null, $nameType = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSurnamePrefix($surnamePrefix)
            ->setSurname($surname)
            ->setNameSuffix($nameSuffix)
            ->setNameTitle($nameTitle)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setNameType($nameType);
    }
    /**
     * Get NamePrefix value
     * @return string[]|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * Set NamePrefix value
     * @throws \InvalidArgumentException
     * @param string[] $namePrefix
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNamePrefix(array $namePrefix = array())
    {
        foreach ($namePrefix as $personNameTypeNamePrefixItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNamePrefixItem)) {
                throw new \InvalidArgumentException(sprintf('The NamePrefix property can only contain items of string, "%s" given', is_object($personNameTypeNamePrefixItem) ? get_class($personNameTypeNamePrefixItem) : gettype($personNameTypeNamePrefixItem)), __LINE__);
            }
        }
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Add item to NamePrefix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToNamePrefix($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NamePrefix property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NamePrefix[] = $item;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setGivenName(array $givenName = array())
    {
        foreach ($givenName as $personNameTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeGivenNameItem)) {
                throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of string, "%s" given', is_object($personNameTypeGivenNameItem) ? get_class($personNameTypeGivenNameItem) : gettype($personNameTypeGivenNameItem)), __LINE__);
            }
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setMiddleName(array $middleName = array())
    {
        foreach ($middleName as $personNameTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeMiddleNameItem)) {
                throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of string, "%s" given', is_object($personNameTypeMiddleNameItem) ? get_class($personNameTypeMiddleNameItem) : gettype($personNameTypeMiddleNameItem)), __LINE__);
            }
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SurnamePrefix value
     * @return string|null
     */
    public function getSurnamePrefix()
    {
        return $this->SurnamePrefix;
    }
    /**
     * Set SurnamePrefix value
     * @param string $surnamePrefix
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setSurnamePrefix($surnamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($surnamePrefix) && !is_string($surnamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surnamePrefix)), __LINE__);
        }
        $this->SurnamePrefix = $surnamePrefix;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string[]|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @throws \InvalidArgumentException
     * @param string[] $nameSuffix
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNameSuffix(array $nameSuffix = array())
    {
        foreach ($nameSuffix as $personNameTypeNameSuffixItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNameSuffixItem)) {
                throw new \InvalidArgumentException(sprintf('The NameSuffix property can only contain items of string, "%s" given', is_object($personNameTypeNameSuffixItem) ? get_class($personNameTypeNameSuffixItem) : gettype($personNameTypeNameSuffixItem)), __LINE__);
            }
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Add item to NameSuffix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToNameSuffix($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NameSuffix property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameSuffix[] = $item;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return string[]|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * Set NameTitle value
     * @throws \InvalidArgumentException
     * @param string[] $nameTitle
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNameTitle(array $nameTitle = array())
    {
        foreach ($nameTitle as $personNameTypeNameTitleItem) {
            // validation for constraint: itemType
            if (!is_string($personNameTypeNameTitleItem)) {
                throw new \InvalidArgumentException(sprintf('The NameTitle property can only contain items of string, "%s" given', is_object($personNameTypeNameTitleItem) ? get_class($personNameTypeNameTitleItem) : gettype($personNameTypeNameTitleItem)), __LINE__);
            }
        }
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Add item to NameTitle value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function addToNameTitle($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NameTitle property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameTitle[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get NameType value
     * @return string|null
     */
    public function getNameType()
    {
        return $this->NameType;
    }
    /**
     * Set NameType value
     * @param string $nameType
     * @return \rdyescapia\StructType\PersonNameType
     */
    public function setNameType($nameType = null)
    {
        // validation for constraint: string
        if (!is_null($nameType) && !is_string($nameType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameType)), __LINE__);
        }
        $this->NameType = $nameType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
