<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType StructType
 * @subpackage Structs
 */
class PaymentFormType extends AbstractStructBase
{
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Cash
     */
    public $Cash;
    /**
     * The LoyaltyRedemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyRedemption
     */
    public $LoyaltyRedemption;
    /**
     * The MiscChargeOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MiscChargeOrder
     */
    public $MiscChargeOrder;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Voucher
     */
    public $Voucher;
    /**
     * The BankAcct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\BankAcctType
     */
    public $BankAcct;
    /**
     * The DirectBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DirectBillType
     */
    public $DirectBill;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CostCenterID
     * @var string
     */
    public $CostCenterID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The PaymentTransactionTypeCode
     * @var string
     */
    public $PaymentTransactionTypeCode;
    /**
     * Constructor method for PaymentFormType
     * @uses PaymentFormType::setCash()
     * @uses PaymentFormType::setLoyaltyRedemption()
     * @uses PaymentFormType::setMiscChargeOrder()
     * @uses PaymentFormType::setVoucher()
     * @uses PaymentFormType::setBankAcct()
     * @uses PaymentFormType::setDirectBill()
     * @uses PaymentFormType::setPaymentCard()
     * @uses PaymentFormType::setShareSynchInd()
     * @uses PaymentFormType::setShareMarketInd()
     * @uses PaymentFormType::setCostCenterID()
     * @uses PaymentFormType::setRPH()
     * @uses PaymentFormType::setPaymentTransactionTypeCode()
     * @param \rdyescapia\StructType\Cash $cash
     * @param \rdyescapia\StructType\LoyaltyRedemption $loyaltyRedemption
     * @param \rdyescapia\StructType\MiscChargeOrder $miscChargeOrder
     * @param \rdyescapia\StructType\Voucher $voucher
     * @param \rdyescapia\StructType\BankAcctType $bankAcct
     * @param \rdyescapia\StructType\DirectBillType $directBill
     * @param \rdyescapia\StructType\PaymentCardType $paymentCard
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $costCenterID
     * @param string $rPH
     * @param string $paymentTransactionTypeCode
     */
    public function __construct(\rdyescapia\StructType\Cash $cash = null, \rdyescapia\StructType\LoyaltyRedemption $loyaltyRedemption = null, \rdyescapia\StructType\MiscChargeOrder $miscChargeOrder = null, \rdyescapia\StructType\Voucher $voucher = null, \rdyescapia\StructType\BankAcctType $bankAcct = null, \rdyescapia\StructType\DirectBillType $directBill = null, \rdyescapia\StructType\PaymentCardType $paymentCard = null, $shareSynchInd = null, $shareMarketInd = null, $costCenterID = null, $rPH = null, $paymentTransactionTypeCode = null)
    {
        $this
            ->setCash($cash)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setMiscChargeOrder($miscChargeOrder)
            ->setVoucher($voucher)
            ->setBankAcct($bankAcct)
            ->setDirectBill($directBill)
            ->setPaymentCard($paymentCard)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCostCenterID($costCenterID)
            ->setRPH($rPH)
            ->setPaymentTransactionTypeCode($paymentTransactionTypeCode);
    }
    /**
     * Get Cash value
     * @return \rdyescapia\StructType\Cash|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param \rdyescapia\StructType\Cash $cash
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setCash(\rdyescapia\StructType\Cash $cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \rdyescapia\StructType\LoyaltyRedemption|null
     */
    public function getLoyaltyRedemption()
    {
        return $this->LoyaltyRedemption;
    }
    /**
     * Set LoyaltyRedemption value
     * @param \rdyescapia\StructType\LoyaltyRedemption $loyaltyRedemption
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setLoyaltyRedemption(\rdyescapia\StructType\LoyaltyRedemption $loyaltyRedemption = null)
    {
        $this->LoyaltyRedemption = $loyaltyRedemption;
        return $this;
    }
    /**
     * Get MiscChargeOrder value
     * @return \rdyescapia\StructType\MiscChargeOrder|null
     */
    public function getMiscChargeOrder()
    {
        return $this->MiscChargeOrder;
    }
    /**
     * Set MiscChargeOrder value
     * @param \rdyescapia\StructType\MiscChargeOrder $miscChargeOrder
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setMiscChargeOrder(\rdyescapia\StructType\MiscChargeOrder $miscChargeOrder = null)
    {
        $this->MiscChargeOrder = $miscChargeOrder;
        return $this;
    }
    /**
     * Get Voucher value
     * @return \rdyescapia\StructType\Voucher|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param \rdyescapia\StructType\Voucher $voucher
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setVoucher(\rdyescapia\StructType\Voucher $voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get BankAcct value
     * @return \rdyescapia\StructType\BankAcctType|null
     */
    public function getBankAcct()
    {
        return $this->BankAcct;
    }
    /**
     * Set BankAcct value
     * @param \rdyescapia\StructType\BankAcctType $bankAcct
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setBankAcct(\rdyescapia\StructType\BankAcctType $bankAcct = null)
    {
        $this->BankAcct = $bankAcct;
        return $this;
    }
    /**
     * Get DirectBill value
     * @return \rdyescapia\StructType\DirectBillType|null
     */
    public function getDirectBill()
    {
        return $this->DirectBill;
    }
    /**
     * Set DirectBill value
     * @param \rdyescapia\StructType\DirectBillType $directBill
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setDirectBill(\rdyescapia\StructType\DirectBillType $directBill = null)
    {
        $this->DirectBill = $directBill;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \rdyescapia\StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \rdyescapia\StructType\PaymentCardType $paymentCard
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setPaymentCard(\rdyescapia\StructType\PaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CostCenterID value
     * @return string|null
     */
    public function getCostCenterID()
    {
        return $this->CostCenterID;
    }
    /**
     * Set CostCenterID value
     * @param string $costCenterID
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setCostCenterID($costCenterID = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterID) && !is_string($costCenterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costCenterID)), __LINE__);
        }
        $this->CostCenterID = $costCenterID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PaymentTransactionTypeCode value
     * @return string|null
     */
    public function getPaymentTransactionTypeCode()
    {
        return $this->PaymentTransactionTypeCode;
    }
    /**
     * Set PaymentTransactionTypeCode value
     * @param string $paymentTransactionTypeCode
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public function setPaymentTransactionTypeCode($paymentTransactionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTransactionTypeCode) && !is_string($paymentTransactionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTransactionTypeCode)), __LINE__);
        }
        $this->PaymentTransactionTypeCode = $paymentTransactionTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\PaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
