<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesType StructType
 * @subpackage Structs
 */
class OperationSchedulesType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\OperationScheduleType[]
     */
    public $OperationSchedule;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * Constructor method for OperationSchedulesType
     * @uses OperationSchedulesType::setOperationSchedule()
     * @uses OperationSchedulesType::setStart()
     * @uses OperationSchedulesType::setDuration()
     * @uses OperationSchedulesType::setEnd()
     * @uses OperationSchedulesType::setRelease()
     * @param \rdyescapia\StructType\OperationScheduleType[] $operationSchedule
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     */
    public function __construct(array $operationSchedule = array(), $start = null, $duration = null, $end = null, $release = null)
    {
        $this
            ->setOperationSchedule($operationSchedule)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release);
    }
    /**
     * Get OperationSchedule value
     * @return \rdyescapia\StructType\OperationScheduleType[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\OperationScheduleType[] $operationSchedule
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        foreach ($operationSchedule as $operationSchedulesTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (!$operationSchedulesTypeOperationScheduleItem instanceof \rdyescapia\StructType\OperationScheduleType) {
                throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of \rdyescapia\StructType\OperationScheduleType, "%s" given', is_object($operationSchedulesTypeOperationScheduleItem) ? get_class($operationSchedulesTypeOperationScheduleItem) : gettype($operationSchedulesTypeOperationScheduleItem)), __LINE__);
            }
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\OperationScheduleType $item
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public function addToOperationSchedule(\rdyescapia\StructType\OperationScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\OperationScheduleType) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of \rdyescapia\StructType\OperationScheduleType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\OperationSchedulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
