<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedTextType StructType
 * @subpackage Structs
 */
class FormattedTextType extends AbstractStructBase
{
    /**
     * The SubSection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FormattedTextSubSectionType[]
     */
    public $SubSection;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for FormattedTextType
     * @uses FormattedTextType::setSubSection()
     * @uses FormattedTextType::setTitle()
     * @uses FormattedTextType::setLanguage()
     * @param \rdyescapia\StructType\FormattedTextSubSectionType[] $subSection
     * @param string $title
     * @param string $language
     */
    public function __construct(array $subSection = array(), $title = null, $language = null)
    {
        $this
            ->setSubSection($subSection)
            ->setTitle($title)
            ->setLanguage($language);
    }
    /**
     * Get SubSection value
     * @return \rdyescapia\StructType\FormattedTextSubSectionType[]|null
     */
    public function getSubSection()
    {
        return $this->SubSection;
    }
    /**
     * Set SubSection value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FormattedTextSubSectionType[] $subSection
     * @return \rdyescapia\StructType\FormattedTextType
     */
    public function setSubSection(array $subSection = array())
    {
        foreach ($subSection as $formattedTextTypeSubSectionItem) {
            // validation for constraint: itemType
            if (!$formattedTextTypeSubSectionItem instanceof \rdyescapia\StructType\FormattedTextSubSectionType) {
                throw new \InvalidArgumentException(sprintf('The SubSection property can only contain items of \rdyescapia\StructType\FormattedTextSubSectionType, "%s" given', is_object($formattedTextTypeSubSectionItem) ? get_class($formattedTextTypeSubSectionItem) : gettype($formattedTextTypeSubSectionItem)), __LINE__);
            }
        }
        $this->SubSection = $subSection;
        return $this;
    }
    /**
     * Add item to SubSection value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FormattedTextSubSectionType $item
     * @return \rdyescapia\StructType\FormattedTextType
     */
    public function addToSubSection(\rdyescapia\StructType\FormattedTextSubSectionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FormattedTextSubSectionType) {
            throw new \InvalidArgumentException(sprintf('The SubSection property can only contain items of \rdyescapia\StructType\FormattedTextSubSectionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SubSection[] = $item;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \rdyescapia\StructType\FormattedTextType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \rdyescapia\StructType\FormattedTextType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\FormattedTextType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
