<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Feature StructType
 * @subpackage Structs
 */
class Feature extends AbstractStructBase
{
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Charge
     */
    public $Charge;
    /**
     * The MultimediaDescriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The DescriptiveText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The AccessibleCode
     * @var string
     */
    public $AccessibleCode;
    /**
     * The SecurityCode
     * @var string
     */
    public $SecurityCode;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The ProximityCode
     * @var string
     */
    public $ProximityCode;
    /**
     * Constructor method for Feature
     * @uses Feature::setCharge()
     * @uses Feature::setMultimediaDescriptions()
     * @uses Feature::setDescriptiveText()
     * @uses Feature::setCodeDetail()
     * @uses Feature::setAccessibleCode()
     * @uses Feature::setSecurityCode()
     * @uses Feature::setExistsCode()
     * @uses Feature::setProximityCode()
     * @param \rdyescapia\StructType\Charge $charge
     * @param \rdyescapia\StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @param string $descriptiveText
     * @param string $codeDetail
     * @param string $accessibleCode
     * @param string $securityCode
     * @param string $existsCode
     * @param string $proximityCode
     */
    public function __construct(\rdyescapia\StructType\Charge $charge = null, \rdyescapia\StructType\MultimediaDescriptionsType $multimediaDescriptions = null, $descriptiveText = null, $codeDetail = null, $accessibleCode = null, $securityCode = null, $existsCode = null, $proximityCode = null)
    {
        $this
            ->setCharge($charge)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setDescriptiveText($descriptiveText)
            ->setCodeDetail($codeDetail)
            ->setAccessibleCode($accessibleCode)
            ->setSecurityCode($securityCode)
            ->setExistsCode($existsCode)
            ->setProximityCode($proximityCode);
    }
    /**
     * Get Charge value
     * @return \rdyescapia\StructType\Charge|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \rdyescapia\StructType\Charge $charge
     * @return \rdyescapia\StructType\Feature
     */
    public function setCharge(\rdyescapia\StructType\Charge $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \rdyescapia\StructType\MultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \rdyescapia\StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @return \rdyescapia\StructType\Feature
     */
    public function setMultimediaDescriptions(\rdyescapia\StructType\MultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \rdyescapia\StructType\Feature
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \rdyescapia\StructType\Feature
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get AccessibleCode value
     * @return string|null
     */
    public function getAccessibleCode()
    {
        return $this->AccessibleCode;
    }
    /**
     * Set AccessibleCode value
     * @param string $accessibleCode
     * @return \rdyescapia\StructType\Feature
     */
    public function setAccessibleCode($accessibleCode = null)
    {
        // validation for constraint: string
        if (!is_null($accessibleCode) && !is_string($accessibleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessibleCode)), __LINE__);
        }
        $this->AccessibleCode = $accessibleCode;
        return $this;
    }
    /**
     * Get SecurityCode value
     * @return string|null
     */
    public function getSecurityCode()
    {
        return $this->SecurityCode;
    }
    /**
     * Set SecurityCode value
     * @param string $securityCode
     * @return \rdyescapia\StructType\Feature
     */
    public function setSecurityCode($securityCode = null)
    {
        // validation for constraint: string
        if (!is_null($securityCode) && !is_string($securityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityCode)), __LINE__);
        }
        $this->SecurityCode = $securityCode;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \rdyescapia\StructType\Feature
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get ProximityCode value
     * @return string|null
     */
    public function getProximityCode()
    {
        return $this->ProximityCode;
    }
    /**
     * Set ProximityCode value
     * @param string $proximityCode
     * @return \rdyescapia\StructType\Feature
     */
    public function setProximityCode($proximityCode = null)
    {
        // validation for constraint: string
        if (!is_null($proximityCode) && !is_string($proximityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proximityCode)), __LINE__);
        }
        $this->ProximityCode = $proximityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\Feature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
