<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_UnitSearchRQ StructType
 * @subpackage Structs
 */
class EVRN_UnitSearchRQ extends EVRN_BaseRQType
{
    /**
     * The Criteria
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitSearchCriteriaType
     */
    public $Criteria;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * The SortOrder
     * @var string
     */
    public $SortOrder;
    /**
     * The SendRateDetails
     * Meta informations extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $SendRateDetails;
    /**
     * The SendUnitSummary
     * Meta informations extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $SendUnitSummary;
    /**
     * The PictureSize
     * Meta informations extracted from the WSDL
     * - default: Thumbnail
     * @var string
     */
    public $PictureSize;
    /**
     * The ResponseType
     * Meta informations extracted from the WSDL
     * - default: PropertyList
     * @var string
     */
    public $ResponseType;
    /**
     * Constructor method for EVRN_UnitSearchRQ
     * @uses EVRN_UnitSearchRQ::setCriteria()
     * @uses EVRN_UnitSearchRQ::setMaxResponses()
     * @uses EVRN_UnitSearchRQ::setSortOrder()
     * @uses EVRN_UnitSearchRQ::setSendRateDetails()
     * @uses EVRN_UnitSearchRQ::setSendUnitSummary()
     * @uses EVRN_UnitSearchRQ::setPictureSize()
     * @uses EVRN_UnitSearchRQ::setResponseType()
     * @param \rdyescapia\StructType\UnitSearchCriteriaType $criteria
     * @param int $maxResponses
     * @param string $sortOrder
     * @param bool $sendRateDetails
     * @param bool $sendUnitSummary
     * @param string $pictureSize
     * @param string $responseType
     */
    public function __construct(\rdyescapia\StructType\UnitSearchCriteriaType $criteria = null, $maxResponses = null, $sortOrder = null, $sendRateDetails = true, $sendUnitSummary = true, $pictureSize = 'Thumbnail', $responseType = 'PropertyList')
    {
        $this
            ->setCriteria($criteria)
            ->setMaxResponses($maxResponses)
            ->setSortOrder($sortOrder)
            ->setSendRateDetails($sendRateDetails)
            ->setSendUnitSummary($sendUnitSummary)
            ->setPictureSize($pictureSize)
            ->setResponseType($responseType);
    }
    /**
     * Get Criteria value
     * @return \rdyescapia\StructType\UnitSearchCriteriaType|null
     */
    public function getCriteria()
    {
        return $this->Criteria;
    }
    /**
     * Set Criteria value
     * @param \rdyescapia\StructType\UnitSearchCriteriaType $criteria
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setCriteria(\rdyescapia\StructType\UnitSearchCriteriaType $criteria = null)
    {
        $this->Criteria = $criteria;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !is_numeric($maxResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param string $sortOrder
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: string
        if (!is_null($sortOrder) && !is_string($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get SendRateDetails value
     * @return bool|null
     */
    public function getSendRateDetails()
    {
        return $this->SendRateDetails;
    }
    /**
     * Set SendRateDetails value
     * @param bool $sendRateDetails
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setSendRateDetails($sendRateDetails = true)
    {
        // validation for constraint: boolean
        if (!is_null($sendRateDetails) && !is_bool($sendRateDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendRateDetails)), __LINE__);
        }
        $this->SendRateDetails = $sendRateDetails;
        return $this;
    }
    /**
     * Get SendUnitSummary value
     * @return bool|null
     */
    public function getSendUnitSummary()
    {
        return $this->SendUnitSummary;
    }
    /**
     * Set SendUnitSummary value
     * @param bool $sendUnitSummary
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setSendUnitSummary($sendUnitSummary = true)
    {
        // validation for constraint: boolean
        if (!is_null($sendUnitSummary) && !is_bool($sendUnitSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendUnitSummary)), __LINE__);
        }
        $this->SendUnitSummary = $sendUnitSummary;
        return $this;
    }
    /**
     * Get PictureSize value
     * @return string|null
     */
    public function getPictureSize()
    {
        return $this->PictureSize;
    }
    /**
     * Set PictureSize value
     * @param string $pictureSize
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setPictureSize($pictureSize = 'Thumbnail')
    {
        // validation for constraint: string
        if (!is_null($pictureSize) && !is_string($pictureSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pictureSize)), __LINE__);
        }
        $this->PictureSize = $pictureSize;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public function setResponseType($responseType = 'PropertyList')
    {
        // validation for constraint: string
        if (!is_null($responseType) && !is_string($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseType)), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\EVRN_UnitSearchRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
