<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_UnitReadRQ StructType
 * @subpackage Structs
 */
class EVRN_UnitReadRQ extends EVRN_BaseRQType
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The ReadRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ReadRequests
     */
    public $ReadRequests;
    /**
     * The ReqRespVersion
     * @var string
     */
    public $ReqRespVersion;
    /**
     * The ReservationType
     * @var string
     */
    public $ReservationType;
    /**
     * The ReturnListIndicator
     * @var bool
     */
    public $ReturnListIndicator;
    /**
     * The MoreIndicator
     * @var bool
     */
    public $MoreIndicator;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * Constructor method for EVRN_UnitReadRQ
     * @uses EVRN_UnitReadRQ::setUniqueID()
     * @uses EVRN_UnitReadRQ::setReadRequests()
     * @uses EVRN_UnitReadRQ::setReqRespVersion()
     * @uses EVRN_UnitReadRQ::setReservationType()
     * @uses EVRN_UnitReadRQ::setReturnListIndicator()
     * @uses EVRN_UnitReadRQ::setMoreIndicator()
     * @uses EVRN_UnitReadRQ::setMoreDataEchoToken()
     * @param \rdyescapia\StructType\UniqueID_Type $uniqueID
     * @param \rdyescapia\StructType\ReadRequests $readRequests
     * @param string $reqRespVersion
     * @param string $reservationType
     * @param bool $returnListIndicator
     * @param bool $moreIndicator
     * @param string $moreDataEchoToken
     */
    public function __construct(\rdyescapia\StructType\UniqueID_Type $uniqueID = null, \rdyescapia\StructType\ReadRequests $readRequests = null, $reqRespVersion = null, $reservationType = null, $returnListIndicator = null, $moreIndicator = null, $moreDataEchoToken = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setReadRequests($readRequests)
            ->setReqRespVersion($reqRespVersion)
            ->setReservationType($reservationType)
            ->setReturnListIndicator($returnListIndicator)
            ->setMoreIndicator($moreIndicator)
            ->setMoreDataEchoToken($moreDataEchoToken);
    }
    /**
     * Get UniqueID value
     * @return \rdyescapia\StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \rdyescapia\StructType\UniqueID_Type $uniqueID
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setUniqueID(\rdyescapia\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get ReadRequests value
     * @return \rdyescapia\StructType\ReadRequests|null
     */
    public function getReadRequests()
    {
        return $this->ReadRequests;
    }
    /**
     * Set ReadRequests value
     * @param \rdyescapia\StructType\ReadRequests $readRequests
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setReadRequests(\rdyescapia\StructType\ReadRequests $readRequests = null)
    {
        $this->ReadRequests = $readRequests;
        return $this;
    }
    /**
     * Get ReqRespVersion value
     * @return string|null
     */
    public function getReqRespVersion()
    {
        return $this->ReqRespVersion;
    }
    /**
     * Set ReqRespVersion value
     * @param string $reqRespVersion
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setReqRespVersion($reqRespVersion = null)
    {
        // validation for constraint: string
        if (!is_null($reqRespVersion) && !is_string($reqRespVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqRespVersion)), __LINE__);
        }
        $this->ReqRespVersion = $reqRespVersion;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @param string $reservationType
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationType)), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
    /**
     * Get ReturnListIndicator value
     * @return bool|null
     */
    public function getReturnListIndicator()
    {
        return $this->ReturnListIndicator;
    }
    /**
     * Set ReturnListIndicator value
     * @param bool $returnListIndicator
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setReturnListIndicator($returnListIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnListIndicator) && !is_bool($returnListIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnListIndicator)), __LINE__);
        }
        $this->ReturnListIndicator = $returnListIndicator;
        return $this;
    }
    /**
     * Get MoreIndicator value
     * @return bool|null
     */
    public function getMoreIndicator()
    {
        return $this->MoreIndicator;
    }
    /**
     * Set MoreIndicator value
     * @param bool $moreIndicator
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setMoreIndicator($moreIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreIndicator) && !is_bool($moreIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreIndicator)), __LINE__);
        }
        $this->MoreIndicator = $moreIndicator;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\EVRN_UnitReadRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
