<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmailType[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Address[]
     */
    public $Address;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\URL_Type[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormType[]
     */
    public $PaymentForm;
    /**
     * The RelatedTraveler
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\RelatedTravelerType[]
     */
    public $RelatedTraveler;
    /**
     * The ContactPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\ContactPersonType[]
     */
    public $ContactPerson;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DocumentType[]
     */
    public $Document;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNameType
     */
    public $EmployerInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Deceased
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * @var string
     */
    public $LockoutType;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The VIP_Indicator
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setURL()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setPhysChallName()
     * @uses CustomerType::setPetInfo()
     * @uses CustomerType::setPaymentForm()
     * @uses CustomerType::setRelatedTraveler()
     * @uses CustomerType::setContactPerson()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setEmployeeInfo()
     * @uses CustomerType::setEmployerInfo()
     * @uses CustomerType::setTPA_Extensions()
     * @uses CustomerType::setGender()
     * @uses CustomerType::setDeceased()
     * @uses CustomerType::setLockoutType()
     * @uses CustomerType::setBirthDate()
     * @uses CustomerType::setCurrencyCode()
     * @uses CustomerType::setDecimalPlaces()
     * @uses CustomerType::setVIP_Indicator()
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @param \rdyescapia\StructType\Telephone[] $telephone
     * @param \rdyescapia\StructType\EmailType[] $email
     * @param \rdyescapia\StructType\Address[] $address
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @param \rdyescapia\StructType\CitizenCountryName[] $citizenCountryName
     * @param string[] $physChallName
     * @param string[] $petInfo
     * @param \rdyescapia\StructType\PaymentFormType[] $paymentForm
     * @param \rdyescapia\StructType\RelatedTravelerType[] $relatedTraveler
     * @param \rdyescapia\StructType\ContactPersonType[] $contactPerson
     * @param \rdyescapia\StructType\DocumentType[] $document
     * @param \rdyescapia\StructType\CustLoyalty[] $custLoyalty
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @param \rdyescapia\StructType\CompanyNameType $employerInfo
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $gender
     * @param bool $deceased
     * @param string $lockoutType
     * @param string $birthDate
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param bool $vIP_Indicator
     */
    public function __construct(\rdyescapia\StructType\PersonNameType $personName = null, array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $relatedTraveler = array(), array $contactPerson = array(), array $document = array(), array $custLoyalty = array(), array $employeeInfo = array(), \rdyescapia\StructType\CompanyNameType $employerInfo = null, \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $gender = null, $deceased = null, $lockoutType = null, $birthDate = null, $currencyCode = null, $decimalPlaces = null, $vIP_Indicator = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setRelatedTraveler($relatedTraveler)
            ->setContactPerson($contactPerson)
            ->setDocument($document)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setGender($gender)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setBirthDate($birthDate)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setVIP_Indicator($vIP_Indicator);
    }
    /**
     * Get PersonName value
     * @return \rdyescapia\StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \rdyescapia\StructType\PersonNameType $personName
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPersonName(\rdyescapia\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \rdyescapia\StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Telephone[] $telephone
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        foreach ($telephone as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \rdyescapia\StructType\Telephone) {
                throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \rdyescapia\StructType\Telephone, "%s" given', is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : gettype($customerTypeTelephoneItem)), __LINE__);
            }
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Telephone $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToTelephone(\rdyescapia\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of \rdyescapia\StructType\Telephone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \rdyescapia\StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType[] $email
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setEmail(array $email = array())
    {
        foreach ($email as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \rdyescapia\StructType\EmailType) {
                throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \rdyescapia\StructType\EmailType, "%s" given', is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : gettype($customerTypeEmailItem)), __LINE__);
            }
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmailType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToEmail(\rdyescapia\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of \rdyescapia\StructType\EmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapia\StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Address[] $address
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \rdyescapia\StructType\Address) {
                throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \rdyescapia\StructType\Address, "%s" given', is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : gettype($customerTypeAddressItem)), __LINE__);
            }
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Address $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToAddress(\rdyescapia\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of \rdyescapia\StructType\Address, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \rdyescapia\StructType\URL_Type[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type[] $uRL
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setURL(array $uRL = array())
    {
        foreach ($uRL as $customerTypeURLItem) {
            // validation for constraint: itemType
            if (!$customerTypeURLItem instanceof \rdyescapia\StructType\URL_Type) {
                throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \rdyescapia\StructType\URL_Type, "%s" given', is_object($customerTypeURLItem) ? get_class($customerTypeURLItem) : gettype($customerTypeURLItem)), __LINE__);
            }
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\URL_Type $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToURL(\rdyescapia\StructType\URL_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\URL_Type) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of \rdyescapia\StructType\URL_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \rdyescapia\StructType\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CitizenCountryName[] $citizenCountryName
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        foreach ($citizenCountryName as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \rdyescapia\StructType\CitizenCountryName) {
                throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of \rdyescapia\StructType\CitizenCountryName, "%s" given', is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : gettype($customerTypeCitizenCountryNameItem)), __LINE__);
            }
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CitizenCountryName $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToCitizenCountryName(\rdyescapia\StructType\CitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of \rdyescapia\StructType\CitizenCountryName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return string[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param string[] $physChallName
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        foreach ($physChallName as $customerTypePhysChallNameItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePhysChallNameItem)) {
                throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of string, "%s" given', is_object($customerTypePhysChallNameItem) ? get_class($customerTypePhysChallNameItem) : gettype($customerTypePhysChallNameItem)), __LINE__);
            }
        }
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToPhysChallName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return string[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param string[] $petInfo
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        foreach ($petInfo as $customerTypePetInfoItem) {
            // validation for constraint: itemType
            if (!is_string($customerTypePetInfoItem)) {
                throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of string, "%s" given', is_object($customerTypePetInfoItem) ? get_class($customerTypePetInfoItem) : gettype($customerTypePetInfoItem)), __LINE__);
            }
        }
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToPetInfo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \rdyescapia\StructType\PaymentFormType[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormType[] $paymentForm
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        foreach ($paymentForm as $customerTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerTypePaymentFormItem instanceof \rdyescapia\StructType\PaymentFormType) {
                throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \rdyescapia\StructType\PaymentFormType, "%s" given', is_object($customerTypePaymentFormItem) ? get_class($customerTypePaymentFormItem) : gettype($customerTypePaymentFormItem)), __LINE__);
            }
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToPaymentForm(\rdyescapia\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of \rdyescapia\StructType\PaymentFormType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get RelatedTraveler value
     * @return \rdyescapia\StructType\RelatedTravelerType[]|null
     */
    public function getRelatedTraveler()
    {
        return $this->RelatedTraveler;
    }
    /**
     * Set RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\RelatedTravelerType[] $relatedTraveler
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setRelatedTraveler(array $relatedTraveler = array())
    {
        foreach ($relatedTraveler as $customerTypeRelatedTravelerItem) {
            // validation for constraint: itemType
            if (!$customerTypeRelatedTravelerItem instanceof \rdyescapia\StructType\RelatedTravelerType) {
                throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of \rdyescapia\StructType\RelatedTravelerType, "%s" given', is_object($customerTypeRelatedTravelerItem) ? get_class($customerTypeRelatedTravelerItem) : gettype($customerTypeRelatedTravelerItem)), __LINE__);
            }
        }
        $this->RelatedTraveler = $relatedTraveler;
        return $this;
    }
    /**
     * Add item to RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\RelatedTravelerType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToRelatedTraveler(\rdyescapia\StructType\RelatedTravelerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\RelatedTravelerType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of \rdyescapia\StructType\RelatedTravelerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedTraveler[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \rdyescapia\StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ContactPersonType[] $contactPerson
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        foreach ($contactPerson as $customerTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$customerTypeContactPersonItem instanceof \rdyescapia\StructType\ContactPersonType) {
                throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \rdyescapia\StructType\ContactPersonType, "%s" given', is_object($customerTypeContactPersonItem) ? get_class($customerTypeContactPersonItem) : gettype($customerTypeContactPersonItem)), __LINE__);
            }
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\ContactPersonType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToContactPerson(\rdyescapia\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of \rdyescapia\StructType\ContactPersonType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \rdyescapia\StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\DocumentType[] $document
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$customerTypeDocumentItem instanceof \rdyescapia\StructType\DocumentType) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \rdyescapia\StructType\DocumentType, "%s" given', is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : gettype($customerTypeDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\DocumentType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToDocument(\rdyescapia\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \rdyescapia\StructType\DocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \rdyescapia\StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustLoyalty[] $custLoyalty
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        foreach ($custLoyalty as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \rdyescapia\StructType\CustLoyalty) {
                throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \rdyescapia\StructType\CustLoyalty, "%s" given', is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : gettype($customerTypeCustLoyaltyItem)), __LINE__);
            }
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CustLoyalty $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToCustLoyalty(\rdyescapia\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \rdyescapia\StructType\CustLoyalty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \rdyescapia\StructType\EmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType[] $employeeInfo
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $customerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmployeeInfoItem instanceof \rdyescapia\StructType\EmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \rdyescapia\StructType\EmployeeInfoType, "%s" given', is_object($customerTypeEmployeeInfoItem) ? get_class($customerTypeEmployeeInfoItem) : gettype($customerTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployeeInfoType $item
     * @return \rdyescapia\StructType\CustomerType
     */
    public function addToEmployeeInfo(\rdyescapia\StructType\EmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \rdyescapia\StructType\EmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return \rdyescapia\StructType\CompanyNameType|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param \rdyescapia\StructType\CompanyNameType $employerInfo
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setEmployerInfo(\rdyescapia\StructType\CompanyNameType $employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutType) && !is_string($lockoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lockoutType)), __LINE__);
        }
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \rdyescapia\StructType\CustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP_Indicator) && !is_bool($vIP_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vIP_Indicator)), __LINE__);
        }
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
