<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlinePrefType StructType
 * @subpackage Structs
 */
class AirlinePrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\LoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The AirportOriginPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AirportPrefType[]
     */
    public $AirportOriginPref;
    /**
     * The AirportRoutePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AirportPrefType[]
     */
    public $AirportRoutePref;
    /**
     * The FareRestrictPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CabinPref[]
     */
    public $CabinPref;
    /**
     * The SeatPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SeatPref[]
     */
    public $SeatPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MealPrefType[]
     */
    public $MealPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The SSR_Pref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SSR_Pref[]
     */
    public $SSR_Pref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\MediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\PetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AirTicketType
     * @var string
     */
    public $AirTicketType;
    /**
     * Constructor method for AirlinePrefType
     * @uses AirlinePrefType::setLoyaltyPref()
     * @uses AirlinePrefType::setVendorPref()
     * @uses AirlinePrefType::setPaymentFormPref()
     * @uses AirlinePrefType::setAirportOriginPref()
     * @uses AirlinePrefType::setAirportRoutePref()
     * @uses AirlinePrefType::setFareRestrictPref()
     * @uses AirlinePrefType::setFlightTypePref()
     * @uses AirlinePrefType::setEquipPref()
     * @uses AirlinePrefType::setCabinPref()
     * @uses AirlinePrefType::setSeatPref()
     * @uses AirlinePrefType::setTicketDistribPref()
     * @uses AirlinePrefType::setMealPref()
     * @uses AirlinePrefType::setSpecRequestPref()
     * @uses AirlinePrefType::setSSR_Pref()
     * @uses AirlinePrefType::setTPA_Extensions()
     * @uses AirlinePrefType::setMediaEntertainPref()
     * @uses AirlinePrefType::setPetInfoPref()
     * @uses AirlinePrefType::setShareSynchInd()
     * @uses AirlinePrefType::setShareMarketInd()
     * @uses AirlinePrefType::setPreferLevel()
     * @uses AirlinePrefType::setSmokingAllowed()
     * @uses AirlinePrefType::setPassengerTypeCode()
     * @uses AirlinePrefType::setAirTicketType()
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @param \rdyescapia\StructType\CompanyNamePrefType[] $vendorPref
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @param \rdyescapia\StructType\AirportPrefType[] $airportOriginPref
     * @param \rdyescapia\StructType\AirportPrefType[] $airportRoutePref
     * @param \rdyescapia\StructType\FareRestrictPref[] $fareRestrictPref
     * @param \rdyescapia\StructType\FlightTypePref[] $flightTypePref
     * @param \rdyescapia\StructType\EquipmentTypePref[] $equipPref
     * @param \rdyescapia\StructType\CabinPref[] $cabinPref
     * @param \rdyescapia\StructType\SeatPref[] $seatPref
     * @param \rdyescapia\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @param \rdyescapia\StructType\MealPrefType[] $mealPref
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @param \rdyescapia\StructType\SSR_Pref[] $sSR_Pref
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param \rdyescapia\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @param \rdyescapia\StructType\PetInfoPrefType[] $petInfoPref
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $preferLevel
     * @param bool $smokingAllowed
     * @param string $passengerTypeCode
     * @param string $airTicketType
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $airportOriginPref = array(), array $airportRoutePref = array(), array $fareRestrictPref = array(), array $flightTypePref = array(), array $equipPref = array(), array $cabinPref = array(), array $seatPref = array(), array $ticketDistribPref = array(), array $mealPref = array(), array $specRequestPref = array(), array $sSR_Pref = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, array $mediaEntertainPref = array(), array $petInfoPref = array(), $shareSynchInd = null, $shareMarketInd = null, $preferLevel = 'Preferred', $smokingAllowed = false, $passengerTypeCode = null, $airTicketType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setAirportOriginPref($airportOriginPref)
            ->setAirportRoutePref($airportRoutePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setSeatPref($seatPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMealPref($mealPref)
            ->setSpecRequestPref($specRequestPref)
            ->setSSR_Pref($sSR_Pref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPreferLevel($preferLevel)
            ->setSmokingAllowed($smokingAllowed)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAirTicketType($airTicketType);
    }
    /**
     * Get LoyaltyPref value
     * @return \rdyescapia\StructType\LoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType[] $loyaltyPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $airlinePrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeLoyaltyPrefItem instanceof \rdyescapia\StructType\LoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapia\StructType\LoyaltyPrefType, "%s" given', is_object($airlinePrefTypeLoyaltyPrefItem) ? get_class($airlinePrefTypeLoyaltyPrefItem) : gettype($airlinePrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\LoyaltyPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToLoyaltyPref(\rdyescapia\StructType\LoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\LoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \rdyescapia\StructType\LoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \rdyescapia\StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNamePrefType[] $vendorPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $airlinePrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeVendorPrefItem instanceof \rdyescapia\StructType\CompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapia\StructType\CompanyNamePrefType, "%s" given', is_object($airlinePrefTypeVendorPrefItem) ? get_class($airlinePrefTypeVendorPrefItem) : gettype($airlinePrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CompanyNamePrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToVendorPref(\rdyescapia\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \rdyescapia\StructType\CompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \rdyescapia\StructType\PaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType[] $paymentFormPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $airlinePrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePaymentFormPrefItem instanceof \rdyescapia\StructType\PaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapia\StructType\PaymentFormPrefType, "%s" given', is_object($airlinePrefTypePaymentFormPrefItem) ? get_class($airlinePrefTypePaymentFormPrefItem) : gettype($airlinePrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PaymentFormPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToPaymentFormPref(\rdyescapia\StructType\PaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \rdyescapia\StructType\PaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get AirportOriginPref value
     * @return \rdyescapia\StructType\AirportPrefType[]|null
     */
    public function getAirportOriginPref()
    {
        return $this->AirportOriginPref;
    }
    /**
     * Set AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType[] $airportOriginPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setAirportOriginPref(array $airportOriginPref = array())
    {
        foreach ($airportOriginPref as $airlinePrefTypeAirportOriginPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportOriginPrefItem instanceof \rdyescapia\StructType\AirportPrefType) {
                throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of \rdyescapia\StructType\AirportPrefType, "%s" given', is_object($airlinePrefTypeAirportOriginPrefItem) ? get_class($airlinePrefTypeAirportOriginPrefItem) : gettype($airlinePrefTypeAirportOriginPrefItem)), __LINE__);
            }
        }
        $this->AirportOriginPref = $airportOriginPref;
        return $this;
    }
    /**
     * Add item to AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToAirportOriginPref(\rdyescapia\StructType\AirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of \rdyescapia\StructType\AirportPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportOriginPref[] = $item;
        return $this;
    }
    /**
     * Get AirportRoutePref value
     * @return \rdyescapia\StructType\AirportPrefType[]|null
     */
    public function getAirportRoutePref()
    {
        return $this->AirportRoutePref;
    }
    /**
     * Set AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType[] $airportRoutePref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setAirportRoutePref(array $airportRoutePref = array())
    {
        foreach ($airportRoutePref as $airlinePrefTypeAirportRoutePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeAirportRoutePrefItem instanceof \rdyescapia\StructType\AirportPrefType) {
                throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of \rdyescapia\StructType\AirportPrefType, "%s" given', is_object($airlinePrefTypeAirportRoutePrefItem) ? get_class($airlinePrefTypeAirportRoutePrefItem) : gettype($airlinePrefTypeAirportRoutePrefItem)), __LINE__);
            }
        }
        $this->AirportRoutePref = $airportRoutePref;
        return $this;
    }
    /**
     * Add item to AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\AirportPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToAirportRoutePref(\rdyescapia\StructType\AirportPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\AirportPrefType) {
            throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of \rdyescapia\StructType\AirportPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirportRoutePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \rdyescapia\StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FareRestrictPref[] $fareRestrictPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        foreach ($fareRestrictPref as $airlinePrefTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFareRestrictPrefItem instanceof \rdyescapia\StructType\FareRestrictPref) {
                throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \rdyescapia\StructType\FareRestrictPref, "%s" given', is_object($airlinePrefTypeFareRestrictPrefItem) ? get_class($airlinePrefTypeFareRestrictPrefItem) : gettype($airlinePrefTypeFareRestrictPrefItem)), __LINE__);
            }
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FareRestrictPref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToFareRestrictPref(\rdyescapia\StructType\FareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of \rdyescapia\StructType\FareRestrictPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \rdyescapia\StructType\FlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FlightTypePref[] $flightTypePref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        foreach ($flightTypePref as $airlinePrefTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFlightTypePrefItem instanceof \rdyescapia\StructType\FlightTypePref) {
                throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \rdyescapia\StructType\FlightTypePref, "%s" given', is_object($airlinePrefTypeFlightTypePrefItem) ? get_class($airlinePrefTypeFlightTypePrefItem) : gettype($airlinePrefTypeFlightTypePrefItem)), __LINE__);
            }
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FlightTypePref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToFlightTypePref(\rdyescapia\StructType\FlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \rdyescapia\StructType\FlightTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \rdyescapia\StructType\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EquipmentTypePref[] $equipPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setEquipPref(array $equipPref = array())
    {
        foreach ($equipPref as $airlinePrefTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeEquipPrefItem instanceof \rdyescapia\StructType\EquipmentTypePref) {
                throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \rdyescapia\StructType\EquipmentTypePref, "%s" given', is_object($airlinePrefTypeEquipPrefItem) ? get_class($airlinePrefTypeEquipPrefItem) : gettype($airlinePrefTypeEquipPrefItem)), __LINE__);
            }
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EquipmentTypePref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToEquipPref(\rdyescapia\StructType\EquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \rdyescapia\StructType\EquipmentTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \rdyescapia\StructType\CabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CabinPref[] $cabinPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        foreach ($cabinPref as $airlinePrefTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeCabinPrefItem instanceof \rdyescapia\StructType\CabinPref) {
                throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \rdyescapia\StructType\CabinPref, "%s" given', is_object($airlinePrefTypeCabinPrefItem) ? get_class($airlinePrefTypeCabinPrefItem) : gettype($airlinePrefTypeCabinPrefItem)), __LINE__);
            }
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CabinPref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToCabinPref(\rdyescapia\StructType\CabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of \rdyescapia\StructType\CabinPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get SeatPref value
     * @return \rdyescapia\StructType\SeatPref[]|null
     */
    public function getSeatPref()
    {
        return $this->SeatPref;
    }
    /**
     * Set SeatPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SeatPref[] $seatPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSeatPref(array $seatPref = array())
    {
        foreach ($seatPref as $airlinePrefTypeSeatPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSeatPrefItem instanceof \rdyescapia\StructType\SeatPref) {
                throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of \rdyescapia\StructType\SeatPref, "%s" given', is_object($airlinePrefTypeSeatPrefItem) ? get_class($airlinePrefTypeSeatPrefItem) : gettype($airlinePrefTypeSeatPrefItem)), __LINE__);
            }
        }
        $this->SeatPref = $seatPref;
        return $this;
    }
    /**
     * Add item to SeatPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SeatPref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToSeatPref(\rdyescapia\StructType\SeatPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SeatPref) {
            throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of \rdyescapia\StructType\SeatPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \rdyescapia\StructType\TicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TicketDistribPrefType[] $ticketDistribPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        foreach ($ticketDistribPref as $airlinePrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeTicketDistribPrefItem instanceof \rdyescapia\StructType\TicketDistribPrefType) {
                throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \rdyescapia\StructType\TicketDistribPrefType, "%s" given', is_object($airlinePrefTypeTicketDistribPrefItem) ? get_class($airlinePrefTypeTicketDistribPrefItem) : gettype($airlinePrefTypeTicketDistribPrefItem)), __LINE__);
            }
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TicketDistribPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToTicketDistribPref(\rdyescapia\StructType\TicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \rdyescapia\StructType\TicketDistribPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \rdyescapia\StructType\MealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MealPrefType[] $mealPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $airlinePrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMealPrefItem instanceof \rdyescapia\StructType\MealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \rdyescapia\StructType\MealPrefType, "%s" given', is_object($airlinePrefTypeMealPrefItem) ? get_class($airlinePrefTypeMealPrefItem) : gettype($airlinePrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MealPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToMealPref(\rdyescapia\StructType\MealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\MealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \rdyescapia\StructType\MealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \rdyescapia\StructType\SpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType[] $specRequestPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $airlinePrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSpecRequestPrefItem instanceof \rdyescapia\StructType\SpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \rdyescapia\StructType\SpecRequestPrefType, "%s" given', is_object($airlinePrefTypeSpecRequestPrefItem) ? get_class($airlinePrefTypeSpecRequestPrefItem) : gettype($airlinePrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecRequestPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToSpecRequestPref(\rdyescapia\StructType\SpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \rdyescapia\StructType\SpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get SSR_Pref value
     * @return \rdyescapia\StructType\SSR_Pref[]|null
     */
    public function getSSR_Pref()
    {
        return $this->SSR_Pref;
    }
    /**
     * Set SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SSR_Pref[] $sSR_Pref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSSR_Pref(array $sSR_Pref = array())
    {
        foreach ($sSR_Pref as $airlinePrefTypeSSR_PrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSSR_PrefItem instanceof \rdyescapia\StructType\SSR_Pref) {
                throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of \rdyescapia\StructType\SSR_Pref, "%s" given', is_object($airlinePrefTypeSSR_PrefItem) ? get_class($airlinePrefTypeSSR_PrefItem) : gettype($airlinePrefTypeSSR_PrefItem)), __LINE__);
            }
        }
        $this->SSR_Pref = $sSR_Pref;
        return $this;
    }
    /**
     * Add item to SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SSR_Pref $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToSSR_Pref(\rdyescapia\StructType\SSR_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SSR_Pref) {
            throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of \rdyescapia\StructType\SSR_Pref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SSR_Pref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \rdyescapia\StructType\MediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MediaEntertainPrefType[] $mediaEntertainPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $airlinePrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeMediaEntertainPrefItem instanceof \rdyescapia\StructType\MediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \rdyescapia\StructType\MediaEntertainPrefType, "%s" given', is_object($airlinePrefTypeMediaEntertainPrefItem) ? get_class($airlinePrefTypeMediaEntertainPrefItem) : gettype($airlinePrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\MediaEntertainPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToMediaEntertainPref(\rdyescapia\StructType\MediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\MediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \rdyescapia\StructType\MediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \rdyescapia\StructType\PetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetInfoPrefType[] $petInfoPref
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $airlinePrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypePetInfoPrefItem instanceof \rdyescapia\StructType\PetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \rdyescapia\StructType\PetInfoPrefType, "%s" given', is_object($airlinePrefTypePetInfoPrefItem) ? get_class($airlinePrefTypePetInfoPrefItem) : gettype($airlinePrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\PetInfoPrefType $item
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function addToPetInfoPref(\rdyescapia\StructType\PetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\PetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \rdyescapia\StructType\PetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \rdyescapia\EnumType\PreferLevelType::valueIsValid()
     * @uses \rdyescapia\EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \rdyescapia\EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AirTicketType value
     * @return string|null
     */
    public function getAirTicketType()
    {
        return $this->AirTicketType;
    }
    /**
     * Set AirTicketType value
     * @uses \rdyescapia\EnumType\TicketType::valueIsValid()
     * @uses \rdyescapia\EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airTicketType
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public function setAirTicketType($airTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\TicketType::valueIsValid($airTicketType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airTicketType, implode(', ', \rdyescapia\EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->AirTicketType = $airTicketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\AirlinePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
