<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliationsType StructType
 * @subpackage Structs
 */
class AffiliationsType extends AbstractStructBase
{
    /**
     * The Organization
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\OrganizationType[]
     */
    public $Organization;
    /**
     * The Employer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\EmployerType[]
     */
    public $Employer;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The TravelClub
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TravelClubType[]
     */
    public $TravelClub;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\InsuranceType[]
     */
    public $Insurance;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for AffiliationsType
     * @uses AffiliationsType::setOrganization()
     * @uses AffiliationsType::setEmployer()
     * @uses AffiliationsType::setTravelArranger()
     * @uses AffiliationsType::setTravelClub()
     * @uses AffiliationsType::setInsurance()
     * @uses AffiliationsType::setTPA_Extensions()
     * @uses AffiliationsType::setShareSynchInd()
     * @uses AffiliationsType::setShareMarketInd()
     * @param \rdyescapia\StructType\OrganizationType[] $organization
     * @param \rdyescapia\StructType\EmployerType[] $employer
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @param \rdyescapia\StructType\TravelClubType[] $travelClub
     * @param \rdyescapia\StructType\InsuranceType[] $insurance
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $organization = array(), array $employer = array(), array $travelArranger = array(), array $travelClub = array(), array $insurance = array(), \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setOrganization($organization)
            ->setEmployer($employer)
            ->setTravelArranger($travelArranger)
            ->setTravelClub($travelClub)
            ->setInsurance($insurance)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get Organization value
     * @return \rdyescapia\StructType\OrganizationType[]|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\OrganizationType[] $organization
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setOrganization(array $organization = array())
    {
        foreach ($organization as $affiliationsTypeOrganizationItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeOrganizationItem instanceof \rdyescapia\StructType\OrganizationType) {
                throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of \rdyescapia\StructType\OrganizationType, "%s" given', is_object($affiliationsTypeOrganizationItem) ? get_class($affiliationsTypeOrganizationItem) : gettype($affiliationsTypeOrganizationItem)), __LINE__);
            }
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Add item to Organization value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\OrganizationType $item
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function addToOrganization(\rdyescapia\StructType\OrganizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\OrganizationType) {
            throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of \rdyescapia\StructType\OrganizationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Organization[] = $item;
        return $this;
    }
    /**
     * Get Employer value
     * @return \rdyescapia\StructType\EmployerType[]|null
     */
    public function getEmployer()
    {
        return $this->Employer;
    }
    /**
     * Set Employer value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployerType[] $employer
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setEmployer(array $employer = array())
    {
        foreach ($employer as $affiliationsTypeEmployerItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeEmployerItem instanceof \rdyescapia\StructType\EmployerType) {
                throw new \InvalidArgumentException(sprintf('The Employer property can only contain items of \rdyescapia\StructType\EmployerType, "%s" given', is_object($affiliationsTypeEmployerItem) ? get_class($affiliationsTypeEmployerItem) : gettype($affiliationsTypeEmployerItem)), __LINE__);
            }
        }
        $this->Employer = $employer;
        return $this;
    }
    /**
     * Add item to Employer value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\EmployerType $item
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function addToEmployer(\rdyescapia\StructType\EmployerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\EmployerType) {
            throw new \InvalidArgumentException(sprintf('The Employer property can only contain items of \rdyescapia\StructType\EmployerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Employer[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \rdyescapia\StructType\TravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType[] $travelArranger
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $affiliationsTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeTravelArrangerItem instanceof \rdyescapia\StructType\TravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \rdyescapia\StructType\TravelArrangerType, "%s" given', is_object($affiliationsTypeTravelArrangerItem) ? get_class($affiliationsTypeTravelArrangerItem) : gettype($affiliationsTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelArrangerType $item
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function addToTravelArranger(\rdyescapia\StructType\TravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \rdyescapia\StructType\TravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get TravelClub value
     * @return \rdyescapia\StructType\TravelClubType[]|null
     */
    public function getTravelClub()
    {
        return $this->TravelClub;
    }
    /**
     * Set TravelClub value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelClubType[] $travelClub
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setTravelClub(array $travelClub = array())
    {
        foreach ($travelClub as $affiliationsTypeTravelClubItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeTravelClubItem instanceof \rdyescapia\StructType\TravelClubType) {
                throw new \InvalidArgumentException(sprintf('The TravelClub property can only contain items of \rdyescapia\StructType\TravelClubType, "%s" given', is_object($affiliationsTypeTravelClubItem) ? get_class($affiliationsTypeTravelClubItem) : gettype($affiliationsTypeTravelClubItem)), __LINE__);
            }
        }
        $this->TravelClub = $travelClub;
        return $this;
    }
    /**
     * Add item to TravelClub value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\TravelClubType $item
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function addToTravelClub(\rdyescapia\StructType\TravelClubType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\TravelClubType) {
            throw new \InvalidArgumentException(sprintf('The TravelClub property can only contain items of \rdyescapia\StructType\TravelClubType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelClub[] = $item;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \rdyescapia\StructType\InsuranceType[]|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InsuranceType[] $insurance
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setInsurance(array $insurance = array())
    {
        foreach ($insurance as $affiliationsTypeInsuranceItem) {
            // validation for constraint: itemType
            if (!$affiliationsTypeInsuranceItem instanceof \rdyescapia\StructType\InsuranceType) {
                throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of \rdyescapia\StructType\InsuranceType, "%s" given', is_object($affiliationsTypeInsuranceItem) ? get_class($affiliationsTypeInsuranceItem) : gettype($affiliationsTypeInsuranceItem)), __LINE__);
            }
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Add item to Insurance value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\InsuranceType $item
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function addToInsurance(\rdyescapia\StructType\InsuranceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\InsuranceType) {
            throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of \rdyescapia\StructType\InsuranceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Insurance[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \rdyescapia\StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setTPA_Extensions(\rdyescapia\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\StructType\AffiliationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
