<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnitStaysTypeUnitStay ArrayType
 * @subpackage Arrays
 */
class ArrayOfUnitStaysTypeUnitStay extends AbstractStructArrayBase
{
    /**
     * The UnitStay
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitStay[]
     */
    public $UnitStay;
    /**
     * Constructor method for ArrayOfUnitStaysTypeUnitStay
     * @uses ArrayOfUnitStaysTypeUnitStay::setUnitStay()
     * @param \rdyescapia\StructType\UnitStay[] $unitStay
     */
    public function __construct(array $unitStay = array())
    {
        $this
            ->setUnitStay($unitStay);
    }
    /**
     * Get UnitStay value
     * @return \rdyescapia\StructType\UnitStay[]|null
     */
    public function getUnitStay()
    {
        return $this->UnitStay;
    }
    /**
     * Set UnitStay value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitStay[] $unitStay
     * @return \rdyescapia\ArrayType\ArrayOfUnitStaysTypeUnitStay
     */
    public function setUnitStay(array $unitStay = array())
    {
        foreach ($unitStay as $arrayOfUnitStaysTypeUnitStayUnitStayItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnitStaysTypeUnitStayUnitStayItem instanceof \rdyescapia\StructType\UnitStay) {
                throw new \InvalidArgumentException(sprintf('The UnitStay property can only contain items of \rdyescapia\StructType\UnitStay, "%s" given', is_object($arrayOfUnitStaysTypeUnitStayUnitStayItem) ? get_class($arrayOfUnitStaysTypeUnitStayUnitStayItem) : gettype($arrayOfUnitStaysTypeUnitStayUnitStayItem)), __LINE__);
            }
        }
        $this->UnitStay = $unitStay;
        return $this;
    }
    /**
     * Add item to UnitStay value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\UnitStay $item
     * @return \rdyescapia\ArrayType\ArrayOfUnitStaysTypeUnitStay
     */
    public function addToUnitStay(\rdyescapia\StructType\UnitStay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\UnitStay) {
            throw new \InvalidArgumentException(sprintf('The UnitStay property can only contain items of \rdyescapia\StructType\UnitStay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitStay[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\UnitStay|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\UnitStay|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\UnitStay|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\UnitStay|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\UnitStay|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UnitStay
     */
    public function getAttributeName()
    {
        return 'UnitStay';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\ArrayType\ArrayOfUnitStaysTypeUnitStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
