<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialRequestTypeSpecialRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfSpecialRequestTypeSpecialRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\SpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for ArrayOfSpecialRequestTypeSpecialRequest
     * @uses ArrayOfSpecialRequestTypeSpecialRequest::setSpecialRequest()
     * @param \rdyescapia\StructType\SpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * @return \rdyescapia\StructType\SpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * Set SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecialRequest[] $specialRequest
     * @return \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        foreach ($specialRequest as $arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem instanceof \rdyescapia\StructType\SpecialRequest) {
                throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of \rdyescapia\StructType\SpecialRequest, "%s" given', is_object($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) ? get_class($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) : gettype($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem)), __LINE__);
            }
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\SpecialRequest $item
     * @return \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public function addToSpecialRequest(\rdyescapia\StructType\SpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\SpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of \rdyescapia\StructType\SpecialRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\SpecialRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialRequest
     */
    public function getAttributeName()
    {
        return 'SpecialRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
