<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeeType ArrayType
 * @subpackage Arrays
 */
class ArrayOfFeeType extends AbstractStructArrayBase
{
    /**
     * The Fee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FeeType[]
     */
    public $Fee;
    /**
     * Constructor method for ArrayOfFeeType
     * @uses ArrayOfFeeType::setFee()
     * @param \rdyescapia\StructType\FeeType[] $fee
     */
    public function __construct(array $fee = array())
    {
        $this
            ->setFee($fee);
    }
    /**
     * Get Fee value
     * @return \rdyescapia\StructType\FeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FeeType[] $fee
     * @return \rdyescapia\ArrayType\ArrayOfFeeType
     */
    public function setFee(array $fee = array())
    {
        foreach ($fee as $arrayOfFeeTypeFeeItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeeTypeFeeItem instanceof \rdyescapia\StructType\FeeType) {
                throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of \rdyescapia\StructType\FeeType, "%s" given', is_object($arrayOfFeeTypeFeeItem) ? get_class($arrayOfFeeTypeFeeItem) : gettype($arrayOfFeeTypeFeeItem)), __LINE__);
            }
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\FeeType $item
     * @return \rdyescapia\ArrayType\ArrayOfFeeType
     */
    public function addToFee(\rdyescapia\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of \rdyescapia\StructType\FeeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\FeeType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\FeeType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\FeeType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\FeeType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\FeeType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fee
     */
    public function getAttributeName()
    {
        return 'Fee';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\ArrayType\ArrayOfFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
