<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEVRN_PoliciesTypePolicy ArrayType
 * @subpackage Arrays
 */
class ArrayOfEVRN_PoliciesTypePolicy extends AbstractStructArrayBase
{
    /**
     * The Policy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Policy[]
     */
    public $Policy;
    /**
     * Constructor method for ArrayOfEVRN_PoliciesTypePolicy
     * @uses ArrayOfEVRN_PoliciesTypePolicy::setPolicy()
     * @param \rdyescapia\StructType\Policy[] $policy
     */
    public function __construct(array $policy = array())
    {
        $this
            ->setPolicy($policy);
    }
    /**
     * Get Policy value
     * @return \rdyescapia\StructType\Policy[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Policy[] $policy
     * @return \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy
     */
    public function setPolicy(array $policy = array())
    {
        foreach ($policy as $arrayOfEVRN_PoliciesTypePolicyPolicyItem) {
            // validation for constraint: itemType
            if (!$arrayOfEVRN_PoliciesTypePolicyPolicyItem instanceof \rdyescapia\StructType\Policy) {
                throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of \rdyescapia\StructType\Policy, "%s" given', is_object($arrayOfEVRN_PoliciesTypePolicyPolicyItem) ? get_class($arrayOfEVRN_PoliciesTypePolicyPolicyItem) : gettype($arrayOfEVRN_PoliciesTypePolicyPolicyItem)), __LINE__);
            }
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\Policy $item
     * @return \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy
     */
    public function addToPolicy(\rdyescapia\StructType\Policy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\Policy) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of \rdyescapia\StructType\Policy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\Policy|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\Policy|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\Policy|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\Policy|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\Policy|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Policy
     */
    public function getAttributeName()
    {
        return 'Policy';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\ArrayType\ArrayOfEVRN_PoliciesTypePolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
