<?php

namespace rdyescapia\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCampaignRequestType ArrayType
 * @subpackage Arrays
 */
class ArrayOfCampaignRequestType extends AbstractStructArrayBase
{
    /**
     * The CampaignRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CampaignRequestType[]
     */
    public $CampaignRequest;
    /**
     * Constructor method for ArrayOfCampaignRequestType
     * @uses ArrayOfCampaignRequestType::setCampaignRequest()
     * @param \rdyescapia\StructType\CampaignRequestType[] $campaignRequest
     */
    public function __construct(array $campaignRequest = array())
    {
        $this
            ->setCampaignRequest($campaignRequest);
    }
    /**
     * Get CampaignRequest value
     * @return \rdyescapia\StructType\CampaignRequestType[]|null
     */
    public function getCampaignRequest()
    {
        return $this->CampaignRequest;
    }
    /**
     * Set CampaignRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CampaignRequestType[] $campaignRequest
     * @return \rdyescapia\ArrayType\ArrayOfCampaignRequestType
     */
    public function setCampaignRequest(array $campaignRequest = array())
    {
        foreach ($campaignRequest as $arrayOfCampaignRequestTypeCampaignRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfCampaignRequestTypeCampaignRequestItem instanceof \rdyescapia\StructType\CampaignRequestType) {
                throw new \InvalidArgumentException(sprintf('The CampaignRequest property can only contain items of \rdyescapia\StructType\CampaignRequestType, "%s" given', is_object($arrayOfCampaignRequestTypeCampaignRequestItem) ? get_class($arrayOfCampaignRequestTypeCampaignRequestItem) : gettype($arrayOfCampaignRequestTypeCampaignRequestItem)), __LINE__);
            }
        }
        $this->CampaignRequest = $campaignRequest;
        return $this;
    }
    /**
     * Add item to CampaignRequest value
     * @throws \InvalidArgumentException
     * @param \rdyescapia\StructType\CampaignRequestType $item
     * @return \rdyescapia\ArrayType\ArrayOfCampaignRequestType
     */
    public function addToCampaignRequest(\rdyescapia\StructType\CampaignRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \rdyescapia\StructType\CampaignRequestType) {
            throw new \InvalidArgumentException(sprintf('The CampaignRequest property can only contain items of \rdyescapia\StructType\CampaignRequestType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CampaignRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \rdyescapia\StructType\CampaignRequestType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \rdyescapia\StructType\CampaignRequestType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \rdyescapia\StructType\CampaignRequestType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \rdyescapia\StructType\CampaignRequestType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \rdyescapia\StructType\CampaignRequestType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CampaignRequest
     */
    public function getAttributeName()
    {
        return 'CampaignRequest';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \rdyescapia\ArrayType\ArrayOfCampaignRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
