<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCoreType StructType
 * @subpackage Structs
 */
class VehicleCoreType extends AbstractStructBase
{
    /**
     * The VehType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\VehType
     */
    public $VehType;
    /**
     * The VehClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\VehClass
     */
    public $VehClass;
    /**
     * The AirConditionInd
     * @var bool
     */
    public $AirConditionInd;
    /**
     * The TransmissionType
     * @var string
     */
    public $TransmissionType;
    /**
     * The FuelType
     * @var string
     */
    public $FuelType;
    /**
     * The DriveType
     * @var string
     */
    public $DriveType;
    /**
     * Constructor method for VehicleCoreType
     * @uses VehicleCoreType::setVehType()
     * @uses VehicleCoreType::setVehClass()
     * @uses VehicleCoreType::setAirConditionInd()
     * @uses VehicleCoreType::setTransmissionType()
     * @uses VehicleCoreType::setFuelType()
     * @uses VehicleCoreType::setDriveType()
     * @param \rdyescapia\StructType\VehType $vehType
     * @param \rdyescapia\StructType\VehClass $vehClass
     * @param bool $airConditionInd
     * @param string $transmissionType
     * @param string $fuelType
     * @param string $driveType
     */
    public function __construct(\rdyescapia\StructType\VehType $vehType = null, \rdyescapia\StructType\VehClass $vehClass = null, $airConditionInd = null, $transmissionType = null, $fuelType = null, $driveType = null)
    {
        $this
            ->setVehType($vehType)
            ->setVehClass($vehClass)
            ->setAirConditionInd($airConditionInd)
            ->setTransmissionType($transmissionType)
            ->setFuelType($fuelType)
            ->setDriveType($driveType);
    }
    /**
     * Get VehType value
     * @return \rdyescapia\StructType\VehType|null
     */
    public function getVehType()
    {
        return $this->VehType;
    }
    /**
     * Set VehType value
     * @param \rdyescapia\StructType\VehType $vehType
     * @return \rdyescapia\StructType\VehicleCoreType
     */
    public function setVehType(\rdyescapia\StructType\VehType $vehType = null)
    {
        $this->VehType = $vehType;
        return $this;
    }
    /**
     * Get VehClass value
     * @return \rdyescapia\StructType\VehClass|null
     */
    public function getVehClass()
    {
        return $this->VehClass;
    }
    /**
     * Set VehClass value
     * @param \rdyescapia\StructType\VehClass $vehClass
     * @return \rdyescapia\StructType\VehicleCoreType
     */
    public function setVehClass(\rdyescapia\StructType\VehClass $vehClass = null)
    {
        $this->VehClass = $vehClass;
        return $this;
    }
    /**
     * Get AirConditionInd value
     * @return bool|null
     */
    public function getAirConditionInd()
    {
        return $this->AirConditionInd;
    }
    /**
     * Set AirConditionInd value
     * @param bool $airConditionInd
     * @return \rdyescapia\StructType\VehicleCoreType
     */
    public function setAirConditionInd($airConditionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($airConditionInd) && !is_bool($airConditionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($airConditionInd, true), gettype($airConditionInd)), __LINE__);
        }
        $this->AirConditionInd = $airConditionInd;
        return $this;
    }
    /**
     * Get TransmissionType value
     * @return string|null
     */
    public function getTransmissionType()
    {
        return $this->TransmissionType;
    }
    /**
     * Set TransmissionType value
     * @uses \rdyescapia\EnumType\VehicleTransmissionType::valueIsValid()
     * @uses \rdyescapia\EnumType\VehicleTransmissionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transmissionType
     * @return \rdyescapia\StructType\VehicleCoreType
     */
    public function setTransmissionType($transmissionType = null)
    {
        // validation for constraint: enumeration
        if (!\rdyescapia\EnumType\VehicleTransmissionType::valueIsValid($transmissionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \rdyescapia\EnumType\VehicleTransmissionType', is_array($transmissionType) ? implode(', ', $transmissionType) : var_export($transmissionType, true), implode(', ', \rdyescapia\EnumType\VehicleTransmissionType::getValidValues())), __LINE__);
        }
        $this->TransmissionType = $transmissionType;
        return $this;
    }
    /**
     * Get FuelType value
     * @return string|null
     */
    public function getFuelType()
    {
        return $this->FuelType;
    }
    /**
     * Set FuelType value
     * @param string $fuelType
     * @return \rdyescapia\StructType\VehicleCoreType
     */
    public function setFuelType($fuelType = null)
    {
        // validation for constraint: string
        if (!is_null($fuelType) && !is_string($fuelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuelType, true), gettype($fuelType)), __LINE__);
        }
        $this->FuelType = $fuelType;
        return $this;
    }
    /**
     * Get DriveType value
     * @return string|null
     */
    public function getDriveType()
    {
        return $this->DriveType;
    }
    /**
     * Set DriveType value
     * @param string $driveType
     * @return \rdyescapia\StructType\VehicleCoreType
     */
    public function setDriveType($driveType = null)
    {
        // validation for constraint: string
        if (!is_null($driveType) && !is_string($driveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driveType, true), gettype($driveType)), __LINE__);
        }
        $this->DriveType = $driveType;
        return $this;
    }
}
