<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Source StructType
 * @subpackage Structs
 */
class Source extends AbstractStructBase
{
    /**
     * The UnitDescriptionURL
     * @var string
     */
    public $UnitDescriptionURL;
    /**
     * Constructor method for Source
     * @uses Source::setUnitDescriptionURL()
     * @param string $unitDescriptionURL
     */
    public function __construct($unitDescriptionURL = null)
    {
        $this
            ->setUnitDescriptionURL($unitDescriptionURL);
    }
    /**
     * Get UnitDescriptionURL value
     * @return string|null
     */
    public function getUnitDescriptionURL()
    {
        return $this->UnitDescriptionURL;
    }
    /**
     * Set UnitDescriptionURL value
     * @param string $unitDescriptionURL
     * @return \rdyescapia\StructType\Source
     */
    public function setUnitDescriptionURL($unitDescriptionURL = null)
    {
        // validation for constraint: string
        if (!is_null($unitDescriptionURL) && !is_string($unitDescriptionURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitDescriptionURL, true), gettype($unitDescriptionURL)), __LINE__);
        }
        $this->UnitDescriptionURL = $unitDescriptionURL;
        return $this;
    }
}
