<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagerRequestType StructType
 * @subpackage Structs
 */
class PropertyManagerRequestType extends AbstractStructBase
{
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The CountryCodeList
     * @var string[]
     */
    public $CountryCodeList;
    /**
     * The StateCodeList
     * @var string[]
     */
    public $StateCodeList;
    /**
     * Constructor method for PropertyManagerRequestType
     * @uses PropertyManagerRequestType::setPropertyManagerCode()
     * @uses PropertyManagerRequestType::setCountryCodeList()
     * @uses PropertyManagerRequestType::setStateCodeList()
     * @param string $propertyManagerCode
     * @param string[] $countryCodeList
     * @param string[] $stateCodeList
     */
    public function __construct($propertyManagerCode = null, array $countryCodeList = array(), array $stateCodeList = array())
    {
        $this
            ->setPropertyManagerCode($propertyManagerCode)
            ->setCountryCodeList($countryCodeList)
            ->setStateCodeList($stateCodeList);
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \rdyescapia\StructType\PropertyManagerRequestType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyManagerCode, true), gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get CountryCodeList value
     * @return string[]|null
     */
    public function getCountryCodeList()
    {
        return $this->CountryCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setCountryCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountryCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryCodeListForArrayConstraintsFromSetCountryCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyManagerRequestTypeCountryCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($propertyManagerRequestTypeCountryCodeListItem)) {
                $invalidValues[] = is_object($propertyManagerRequestTypeCountryCodeListItem) ? get_class($propertyManagerRequestTypeCountryCodeListItem) : sprintf('%s(%s)', gettype($propertyManagerRequestTypeCountryCodeListItem), var_export($propertyManagerRequestTypeCountryCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CountryCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $countryCodeList
     * @return \rdyescapia\StructType\PropertyManagerRequestType
     */
    public function setCountryCodeList(array $countryCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($countryCodeListArrayErrorMessage = self::validateCountryCodeListForArrayConstraintsFromSetCountryCodeList($countryCodeList))) {
            throw new \InvalidArgumentException($countryCodeListArrayErrorMessage, __LINE__);
        }
        $this->CountryCodeList = $countryCodeList;
        return $this;
    }
    /**
     * Add item to CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PropertyManagerRequestType
     */
    public function addToCountryCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CountryCodeList[] = $item;
        return $this;
    }
    /**
     * Get StateCodeList value
     * @return string[]|null
     */
    public function getStateCodeList()
    {
        return $this->StateCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setStateCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStateCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateCodeListForArrayConstraintsFromSetStateCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyManagerRequestTypeStateCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($propertyManagerRequestTypeStateCodeListItem)) {
                $invalidValues[] = is_object($propertyManagerRequestTypeStateCodeListItem) ? get_class($propertyManagerRequestTypeStateCodeListItem) : sprintf('%s(%s)', gettype($propertyManagerRequestTypeStateCodeListItem), var_export($propertyManagerRequestTypeStateCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StateCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StateCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $stateCodeList
     * @return \rdyescapia\StructType\PropertyManagerRequestType
     */
    public function setStateCodeList(array $stateCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($stateCodeListArrayErrorMessage = self::validateStateCodeListForArrayConstraintsFromSetStateCodeList($stateCodeList))) {
            throw new \InvalidArgumentException($stateCodeListArrayErrorMessage, __LINE__);
        }
        $this->StateCodeList = $stateCodeList;
        return $this;
    }
    /**
     * Add item to StateCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \rdyescapia\StructType\PropertyManagerRequestType
     */
    public function addToStateCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StateCodeList[] = $item;
        return $this;
    }
}
