<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastMinuteDiscountRangeType StructType
 * @subpackage Structs
 */
class LastMinuteDiscountRangeType extends AbstractStructBase
{
    /**
     * The MinAdvanceBookingOffset
     * @var string
     */
    public $MinAdvanceBookingOffset;
    /**
     * The MaxAdvanceBookingOffset
     * @var string
     */
    public $MaxAdvanceBookingOffset;
    /**
     * The MinDiscountPercent
     * @var float
     */
    public $MinDiscountPercent;
    /**
     * The MaxDiscountPercent
     * @var float
     */
    public $MaxDiscountPercent;
    /**
     * Constructor method for LastMinuteDiscountRangeType
     * @uses LastMinuteDiscountRangeType::setMinAdvanceBookingOffset()
     * @uses LastMinuteDiscountRangeType::setMaxAdvanceBookingOffset()
     * @uses LastMinuteDiscountRangeType::setMinDiscountPercent()
     * @uses LastMinuteDiscountRangeType::setMaxDiscountPercent()
     * @param string $minAdvanceBookingOffset
     * @param string $maxAdvanceBookingOffset
     * @param float $minDiscountPercent
     * @param float $maxDiscountPercent
     */
    public function __construct($minAdvanceBookingOffset = null, $maxAdvanceBookingOffset = null, $minDiscountPercent = null, $maxDiscountPercent = null)
    {
        $this
            ->setMinAdvanceBookingOffset($minAdvanceBookingOffset)
            ->setMaxAdvanceBookingOffset($maxAdvanceBookingOffset)
            ->setMinDiscountPercent($minDiscountPercent)
            ->setMaxDiscountPercent($maxDiscountPercent);
    }
    /**
     * Get MinAdvanceBookingOffset value
     * @return string|null
     */
    public function getMinAdvanceBookingOffset()
    {
        return $this->MinAdvanceBookingOffset;
    }
    /**
     * Set MinAdvanceBookingOffset value
     * @param string $minAdvanceBookingOffset
     * @return \rdyescapia\StructType\LastMinuteDiscountRangeType
     */
    public function setMinAdvanceBookingOffset($minAdvanceBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvanceBookingOffset) && !is_string($minAdvanceBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAdvanceBookingOffset, true), gettype($minAdvanceBookingOffset)), __LINE__);
        }
        $this->MinAdvanceBookingOffset = $minAdvanceBookingOffset;
        return $this;
    }
    /**
     * Get MaxAdvanceBookingOffset value
     * @return string|null
     */
    public function getMaxAdvanceBookingOffset()
    {
        return $this->MaxAdvanceBookingOffset;
    }
    /**
     * Set MaxAdvanceBookingOffset value
     * @param string $maxAdvanceBookingOffset
     * @return \rdyescapia\StructType\LastMinuteDiscountRangeType
     */
    public function setMaxAdvanceBookingOffset($maxAdvanceBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvanceBookingOffset) && !is_string($maxAdvanceBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAdvanceBookingOffset, true), gettype($maxAdvanceBookingOffset)), __LINE__);
        }
        $this->MaxAdvanceBookingOffset = $maxAdvanceBookingOffset;
        return $this;
    }
    /**
     * Get MinDiscountPercent value
     * @return float|null
     */
    public function getMinDiscountPercent()
    {
        return $this->MinDiscountPercent;
    }
    /**
     * Set MinDiscountPercent value
     * @param float $minDiscountPercent
     * @return \rdyescapia\StructType\LastMinuteDiscountRangeType
     */
    public function setMinDiscountPercent($minDiscountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($minDiscountPercent) && !(is_float($minDiscountPercent) || is_numeric($minDiscountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minDiscountPercent, true), gettype($minDiscountPercent)), __LINE__);
        }
        $this->MinDiscountPercent = $minDiscountPercent;
        return $this;
    }
    /**
     * Get MaxDiscountPercent value
     * @return float|null
     */
    public function getMaxDiscountPercent()
    {
        return $this->MaxDiscountPercent;
    }
    /**
     * Set MaxDiscountPercent value
     * @param float $maxDiscountPercent
     * @return \rdyescapia\StructType\LastMinuteDiscountRangeType
     */
    public function setMaxDiscountPercent($maxDiscountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($maxDiscountPercent) && !(is_float($maxDiscountPercent) || is_numeric($maxDiscountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxDiscountPercent, true), gettype($maxDiscountPercent)), __LINE__);
        }
        $this->MaxDiscountPercent = $maxDiscountPercent;
        return $this;
    }
}
