<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InquiryRequestType StructType
 * @subpackage Structs
 */
class InquiryRequestType extends AbstractStructBase
{
    /**
     * The UnitRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Contact
     */
    public $Contact;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\FormattedTextTextType
     */
    public $Message;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\Source
     */
    public $Source;
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The InquiryType
     * @var string
     */
    public $InquiryType;
    /**
     * The InquiryDate
     * @var string
     */
    public $InquiryDate;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * Constructor method for InquiryRequestType
     * @uses InquiryRequestType::setUnitRef()
     * @uses InquiryRequestType::setContact()
     * @uses InquiryRequestType::setMessage()
     * @uses InquiryRequestType::setSource()
     * @uses InquiryRequestType::setStayDateRange()
     * @uses InquiryRequestType::setGuestCounts()
     * @uses InquiryRequestType::setInquiryType()
     * @uses InquiryRequestType::setInquiryDate()
     * @uses InquiryRequestType::setTransactionIdentifier()
     * @param \rdyescapia\StructType\UnitRef $unitRef
     * @param \rdyescapia\StructType\Contact $contact
     * @param \rdyescapia\StructType\FormattedTextTextType $message
     * @param \rdyescapia\StructType\Source $source
     * @param \rdyescapia\StructType\DateTimeSpanType $stayDateRange
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @param string $inquiryType
     * @param string $inquiryDate
     * @param string $transactionIdentifier
     */
    public function __construct(\rdyescapia\StructType\UnitRef $unitRef = null, \rdyescapia\StructType\Contact $contact = null, \rdyescapia\StructType\FormattedTextTextType $message = null, \rdyescapia\StructType\Source $source = null, \rdyescapia\StructType\DateTimeSpanType $stayDateRange = null, \rdyescapia\StructType\GuestCountType $guestCounts = null, $inquiryType = null, $inquiryDate = null, $transactionIdentifier = null)
    {
        $this
            ->setUnitRef($unitRef)
            ->setContact($contact)
            ->setMessage($message)
            ->setSource($source)
            ->setStayDateRange($stayDateRange)
            ->setGuestCounts($guestCounts)
            ->setInquiryType($inquiryType)
            ->setInquiryDate($inquiryDate)
            ->setTransactionIdentifier($transactionIdentifier);
    }
    /**
     * Get UnitRef value
     * @return \rdyescapia\StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \rdyescapia\StructType\UnitRef $unitRef
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setUnitRef(\rdyescapia\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get Contact value
     * @return \rdyescapia\StructType\Contact|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \rdyescapia\StructType\Contact $contact
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setContact(\rdyescapia\StructType\Contact $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Message value
     * @return \rdyescapia\StructType\FormattedTextTextType|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \rdyescapia\StructType\FormattedTextTextType $message
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setMessage(\rdyescapia\StructType\FormattedTextTextType $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Source value
     * @return \rdyescapia\StructType\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \rdyescapia\StructType\Source $source
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setSource(\rdyescapia\StructType\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \rdyescapia\StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \rdyescapia\StructType\DateTimeSpanType $stayDateRange
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setStayDateRange(\rdyescapia\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \rdyescapia\StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \rdyescapia\StructType\GuestCountType $guestCounts
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setGuestCounts(\rdyescapia\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get InquiryType value
     * @return string|null
     */
    public function getInquiryType()
    {
        return $this->InquiryType;
    }
    /**
     * Set InquiryType value
     * @param string $inquiryType
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setInquiryType($inquiryType = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryType) && !is_string($inquiryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inquiryType, true), gettype($inquiryType)), __LINE__);
        }
        $this->InquiryType = $inquiryType;
        return $this;
    }
    /**
     * Get InquiryDate value
     * @return string|null
     */
    public function getInquiryDate()
    {
        return $this->InquiryDate;
    }
    /**
     * Set InquiryDate value
     * @param string $inquiryDate
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setInquiryDate($inquiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryDate) && !is_string($inquiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inquiryDate, true), gettype($inquiryDate)), __LINE__);
        }
        $this->InquiryDate = $inquiryDate;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \rdyescapia\StructType\InquiryRequestType
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
}
