<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectBillType StructType
 * @subpackage Structs
 */
class DirectBillType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\CompanyName
     */
    public $CompanyName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \rdyescapia\StructType\AddressInfoType
     */
    public $Address;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The DirectBill_ID
     * @var string
     */
    public $DirectBill_ID;
    /**
     * Constructor method for DirectBillType
     * @uses DirectBillType::setCompanyName()
     * @uses DirectBillType::setAddress()
     * @uses DirectBillType::setShareSynchInd()
     * @uses DirectBillType::setShareMarketInd()
     * @uses DirectBillType::setDirectBill_ID()
     * @param \rdyescapia\StructType\CompanyName $companyName
     * @param \rdyescapia\StructType\AddressInfoType $address
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $directBill_ID
     */
    public function __construct(\rdyescapia\StructType\CompanyName $companyName = null, \rdyescapia\StructType\AddressInfoType $address = null, $shareSynchInd = null, $shareMarketInd = null, $directBill_ID = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setDirectBill_ID($directBill_ID);
    }
    /**
     * Get CompanyName value
     * @return \rdyescapia\StructType\CompanyName|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \rdyescapia\StructType\CompanyName $companyName
     * @return \rdyescapia\StructType\DirectBillType
     */
    public function setCompanyName(\rdyescapia\StructType\CompanyName $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \rdyescapia\StructType\AddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \rdyescapia\StructType\AddressInfoType $address
     * @return \rdyescapia\StructType\DirectBillType
     */
    public function setAddress(\rdyescapia\StructType\AddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\DirectBillType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\DirectBillType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get DirectBill_ID value
     * @return string|null
     */
    public function getDirectBill_ID()
    {
        return $this->DirectBill_ID;
    }
    /**
     * Set DirectBill_ID value
     * @param string $directBill_ID
     * @return \rdyescapia\StructType\DirectBillType
     */
    public function setDirectBill_ID($directBill_ID = null)
    {
        // validation for constraint: string
        if (!is_null($directBill_ID) && !is_string($directBill_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directBill_ID, true), gettype($directBill_ID)), __LINE__);
        }
        $this->DirectBill_ID = $directBill_ID;
        return $this;
    }
}
