<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionInfoType StructType
 * @subpackage Structs
 */
class CommissionInfoType extends FreeTextType
{
    /**
     * The _
     * @var \rdyescapia\StructType\FreeTextType
     */
    public $_;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CommissionPlanCode
     * @var string
     */
    public $CommissionPlanCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for CommissionInfoType
     * @uses CommissionInfoType::set_()
     * @uses CommissionInfoType::setShareSynchInd()
     * @uses CommissionInfoType::setShareMarketInd()
     * @uses CommissionInfoType::setCommissionPlanCode()
     * @uses CommissionInfoType::setAmount()
     * @param \rdyescapia\StructType\FreeTextType $_
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $commissionPlanCode
     * @param float $amount
     */
    public function __construct(\rdyescapia\StructType\FreeTextType $_ = null, $shareSynchInd = null, $shareMarketInd = null, $commissionPlanCode = null, $amount = null)
    {
        $this
            ->set_($_)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCommissionPlanCode($commissionPlanCode)
            ->setAmount($amount);
    }
    /**
     * Get _ value
     * @return \rdyescapia\StructType\FreeTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \rdyescapia\StructType\FreeTextType $_
     * @return \rdyescapia\StructType\CommissionInfoType
     */
    public function set_(\rdyescapia\StructType\FreeTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \rdyescapia\StructType\CommissionInfoType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \rdyescapia\StructType\CommissionInfoType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CommissionPlanCode value
     * @return string|null
     */
    public function getCommissionPlanCode()
    {
        return $this->CommissionPlanCode;
    }
    /**
     * Set CommissionPlanCode value
     * @param string $commissionPlanCode
     * @return \rdyescapia\StructType\CommissionInfoType
     */
    public function setCommissionPlanCode($commissionPlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($commissionPlanCode) && !is_string($commissionPlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionPlanCode, true), gettype($commissionPlanCode)), __LINE__);
        }
        $this->CommissionPlanCode = $commissionPlanCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \rdyescapia\StructType\CommissionInfoType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
