<?php

namespace rdyescapia\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardIssuerName StructType
 * @subpackage Structs
 */
class CardIssuerName extends AbstractStructBase
{
    /**
     * The BankID
     * @var string
     */
    public $BankID;
    /**
     * Constructor method for CardIssuerName
     * @uses CardIssuerName::setBankID()
     * @param string $bankID
     */
    public function __construct($bankID = null)
    {
        $this
            ->setBankID($bankID);
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \rdyescapia\StructType\CardIssuerName
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
}
