<?php

namespace rdyescapia\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unit ServiceType
 * @subpackage Services
 */
class Unit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnitDescriptiveInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ
     * @return \rdyescapia\StructType\EVRN_UnitDescriptiveInfoRS|bool
     */
    public function UnitDescriptiveInfo(\rdyescapia\StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitDescriptiveInfo($eVRN_UnitDescriptiveInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitSearchRQ $eVRN_UnitSearchRQ
     * @return \rdyescapia\StructType\EVRN_UnitSearchRS|bool
     */
    public function UnitSearch(\rdyescapia\StructType\EVRN_UnitSearchRQ $eVRN_UnitSearchRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitSearch($eVRN_UnitSearchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ
     * @return \rdyescapia\StructType\EVRN_UnitCalendarAvailRS|bool
     */
    public function UnitCalendarAvail(\rdyescapia\StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitCalendarAvail($eVRN_UnitCalendarAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitStay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitStayRQ $eVRN_UnitStayRQ
     * @return \rdyescapia\StructType\EVRN_UnitStayRS|bool
     */
    public function UnitStay(\rdyescapia\StructType\EVRN_UnitStayRQ $eVRN_UnitStayRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitStay($eVRN_UnitStayRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitRes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\UnitResRequestType $eVRN_UnitResRQ
     * @return \rdyescapia\StructType\UnitResResponseType|bool
     */
    public function UnitRes(\rdyescapia\StructType\UnitResRequestType $eVRN_UnitResRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitRes($eVRN_UnitResRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitReadRQ $eVRN_UnitReadRQ
     * @return \rdyescapia\StructType\UnitResResponseType|bool
     */
    public function UnitRead(\rdyescapia\StructType\EVRN_UnitReadRQ $eVRN_UnitReadRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitRead($eVRN_UnitReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitInquiry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitInquiryRQ $eVRN_UnitInquiryRQ
     * @return \rdyescapia\StructType\EVRN_UnitInquiryRS|bool
     */
    public function UnitInquiry(\rdyescapia\StructType\EVRN_UnitInquiryRQ $eVRN_UnitInquiryRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitInquiry($eVRN_UnitInquiryRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvailBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ
     * @return \rdyescapia\StructType\EVRN_UnitCalendarAvailBatchRSType|bool
     */
    public function UnitCalendarAvailBatch(\rdyescapia\StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitCalendarAvailBatch($eVRN_UnitCalendarAvailBatchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitHold
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitHoldRQ $eVRN_UnitHoldRQ
     * @return \rdyescapia\StructType\EVRN_UnitHoldRS|bool
     */
    public function UnitHold(\rdyescapia\StructType\EVRN_UnitHoldRQ $eVRN_UnitHoldRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitHold($eVRN_UnitHoldRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvailExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \rdyescapia\StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ
     * @return \rdyescapia\StructType\EVRN_UnitCalendarAvailRS|bool
     */
    public function UnitCalendarAvailExtended(\rdyescapia\StructType\EVRN_UnitCalendarAvailRQ $eVRN_UnitCalendarAvailRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitCalendarAvailExtended($eVRN_UnitCalendarAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \rdyescapia\StructType\EVRN_UnitCalendarAvailBatchRSType|\rdyescapia\StructType\EVRN_UnitCalendarAvailRS|\rdyescapia\StructType\EVRN_UnitDescriptiveInfoRS|\rdyescapia\StructType\EVRN_UnitHoldRS|\rdyescapia\StructType\EVRN_UnitInquiryRS|\rdyescapia\StructType\EVRN_UnitSearchRS|\rdyescapia\StructType\EVRN_UnitStayRS|\rdyescapia\StructType\UnitResResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
